/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.AttachmentUtils;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.GroovyScriptPath;
import hudson.plugins.emailext.MailAccount;
import hudson.plugins.emailext.MatrixTriggerMode;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.groovy.sandbox.EmailExtScriptTokenMacroWhitelist;
import hudson.plugins.emailext.groovy.sandbox.MimeMessageInstanceWhitelist;
import hudson.plugins.emailext.groovy.sandbox.PrintStreamInstanceWhitelist;
import hudson.plugins.emailext.groovy.sandbox.PropertiesInstanceWhitelist;
import hudson.plugins.emailext.groovy.sandbox.TaskListenerInstanceWhitelist;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.CssInliner;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.content.AbstractEvalContent;
import hudson.plugins.emailext.plugins.content.EmailExtScript;
import hudson.plugins.emailext.plugins.content.TriggerNameContent;
import hudson.plugins.emailext.watching.EmailExtWatchAction;
import hudson.plugins.emailext.watching.EmailExtWatchJobProperty;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class ExtendedEmailPublisher
extends Notifier
implements MatrixAggregatable {
    private static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisher.class.getName());
    private static final String CONTENT_TRANSFER_ENCODING = System.getProperty(ExtendedEmailPublisher.class.getName() + ".Content-Transfer-Encoding");
    public static final String DEFAULT_SUBJECT_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
    public static final String DEFAULT_BODY_TEXT = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
    public static final String DEFAULT_EMERGENCY_REROUTE_TEXT = "";
    public static final String PROJECT_DEFAULT_SUBJECT_TEXT = "$PROJECT_DEFAULT_SUBJECT";
    public static final String PROJECT_DEFAULT_BODY_TEXT = "$PROJECT_DEFAULT_CONTENT";
    public String recipientList = "";
    public List<EmailTrigger> configuredTriggers = new ArrayList<EmailTrigger>();
    public String contentType;
    public String defaultSubject;
    public String defaultContent;
    public String attachmentsPattern;
    private String presendScript;
    private String postsendScript;
    private List<GroovyScriptPath> classpath;
    public boolean attachBuildLog;
    public boolean compressBuildLog;
    public String replyTo;
    public String from;
    public boolean saveOutput = false;
    public boolean disabled = false;
    public MatrixTriggerMode matrixTriggerMode;

    public ExtendedEmailPublisher() {
    }

    @Deprecated
    public ExtendedEmailPublisher(String project_recipient_list, String project_content_type, String project_default_subject, String project_default_content, String project_attachments, String project_presend_script, int project_attach_buildlog, String project_replyto, String project_from, boolean project_save_output, List<EmailTrigger> project_triggers, MatrixTriggerMode matrixTriggerMode) {
        this(project_recipient_list, project_content_type, project_default_subject, project_default_content, project_attachments, project_presend_script, project_attach_buildlog, project_replyto, project_from, project_save_output, project_triggers, matrixTriggerMode, false, Collections.emptyList());
    }

    @DataBoundConstructor
    public ExtendedEmailPublisher(String project_recipient_list, String project_content_type, String project_default_subject, String project_default_content, String project_attachments, String project_presend_script, int project_attach_buildlog, String project_replyto, String project_from, boolean project_save_output, List<EmailTrigger> project_triggers, MatrixTriggerMode matrixTriggerMode, boolean project_disabled, List<GroovyScriptPath> classpath) {
        this.recipientList = project_recipient_list;
        this.contentType = project_content_type;
        this.defaultSubject = project_default_subject;
        this.defaultContent = project_default_content;
        this.attachmentsPattern = project_attachments;
        this.setPresendScript(project_presend_script);
        this.attachBuildLog = project_attach_buildlog > 0;
        this.compressBuildLog = project_attach_buildlog > 1;
        this.replyTo = project_replyto;
        this.from = project_from;
        this.saveOutput = project_save_output;
        this.configuredTriggers = project_triggers;
        this.matrixTriggerMode = matrixTriggerMode;
        this.disabled = project_disabled;
        this.setClasspath(classpath);
    }

    public List<GroovyScriptPath> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(List<GroovyScriptPath> classpath) {
        if (classpath != null && !classpath.isEmpty() && Jenkins.get().isUseSecurity()) {
            ScriptApproval scriptApproval = ScriptApproval.get();
            ApprovalContext context = ApprovalContext.create().withCurrentUser();
            StaplerRequest request = Stapler.getCurrentRequest();
            if (request != null) {
                context = context.withItem((Item)request.findAncestorObject(Item.class));
            }
            for (GroovyScriptPath path : classpath) {
                URL pUrl = path.asURL();
                if (pUrl == null) continue;
                try {
                    scriptApproval.configuring(new ClasspathEntry(pUrl.toString()), context);
                }
                catch (MalformedURLException e) {
                    assert (false) : e;
                }
            }
        }
        this.classpath = classpath;
    }

    public void setPresendScript(String presendScript) {
        if (!StringUtils.isBlank((String)(presendScript = StringUtils.trim((String)presendScript))) && !"$DEFAULT_PRESEND_SCRIPT".equals(presendScript)) {
            Ancestor ancestor;
            ScriptApproval scriptApproval = ScriptApproval.get();
            ApprovalContext context = ApprovalContext.create().withCurrentUser();
            StaplerRequest request = Stapler.getCurrentRequest();
            if (request != null && (ancestor = request.findAncestor(Item.class)) != null) {
                context = context.withItem((Item)ancestor.getObject());
            }
            scriptApproval.configuring(presendScript, GroovyLanguage.get(), context);
        }
        this.presendScript = presendScript;
    }

    @DataBoundSetter
    public void setPostsendScript(String postsendScript) {
        if (!StringUtils.isBlank((String)(postsendScript = StringUtils.trim((String)postsendScript))) && !"$DEFAULT_POSTSEND_SCRIPT".equals(postsendScript)) {
            Ancestor ancestor;
            ScriptApproval scriptApproval = ScriptApproval.get();
            ApprovalContext context = ApprovalContext.create().withCurrentUser();
            StaplerRequest request = Stapler.getCurrentRequest();
            if (request != null && (ancestor = request.findAncestor(Item.class)) != null) {
                context = context.withItem((Item)ancestor.getObject());
            }
            scriptApproval.configuring(postsendScript, GroovyLanguage.get(), context);
        }
        this.postsendScript = postsendScript;
    }

    public String getPresendScript() {
        return this.presendScript;
    }

    public String getPostsendScript() {
        return this.postsendScript;
    }

    public List<EmailTrigger> getConfiguredTriggers() {
        if (this.configuredTriggers == null) {
            this.configuredTriggers = new ArrayList<EmailTrigger>();
        }
        return this.configuredTriggers;
    }

    public MatrixTriggerMode getMatrixTriggerMode() {
        return this.matrixTriggerMode == null ? MatrixTriggerMode.BOTH : this.matrixTriggerMode;
    }

    public void setMatrixTriggerMode(MatrixTriggerMode matrixTriggerMode) {
        this.matrixTriggerMode = matrixTriggerMode;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singletonList(new EmailExtWatchAction(project));
    }

    public void debug(PrintStream p, String format, Object ... args) {
        this.getDescriptor().debug(p, format, args);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.debug(listener.getLogger(), "Checking for pre-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Executing pre-build step", new Object[0]);
            return this._perform(build, null, listener, true);
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.debug(listener.getLogger(), "Checking for post-build", new Object[0]);
        if (!(build instanceof MatrixRun) || this.isExecuteOnMatrixNodes()) {
            this.debug(listener.getLogger(), "Performing post-build step", new Object[0]);
            return this._perform(build, launcher, listener, false);
        }
        return true;
    }

    private boolean _perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, boolean forPreBuild) {
        if (this.disabled) {
            listener.getLogger().println("Extended Email Publisher is currently disabled in project settings");
            return true;
        }
        boolean emailTriggered = false;
        this.debug(listener.getLogger(), "Checking if email needs to be generated", new Object[0]);
        ArrayListMultimap triggered = ArrayListMultimap.create();
        for (EmailTrigger emailTrigger : this.getConfiguredTriggers()) {
            if (emailTrigger.isPreBuild() != forPreBuild || !emailTrigger.trigger(build, (TaskListener)listener)) continue;
            Object tName = emailTrigger.getDescriptor().getDisplayName();
            triggered.put(tName, (Object)emailTrigger);
            listener.getLogger().println("Email was triggered for: " + tName);
            emailTriggered = true;
        }
        ArrayList<String> replacedTriggers = new ArrayList<String>();
        for (Object tName : triggered.keySet()) {
            String triggerName = (String)tName;
            for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                replacedTriggers.addAll(trigger.getDescriptor().getTriggerReplaceList());
            }
        }
        for (String triggerName : replacedTriggers) {
            triggered.removeAll((Object)triggerName);
            listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
        }
        EmailExtWatchJobProperty emailExtWatchJobProperty = (EmailExtWatchJobProperty)((AbstractProject)build.getParent()).getProperty(EmailExtWatchJobProperty.class);
        if (emailExtWatchJobProperty != null) {
            for (String u : emailExtWatchJobProperty.getWatchers()) {
                EmailExtWatchAction.UserProperty prop;
                User user = User.get((String)u);
                if (user == null || (prop = (EmailExtWatchAction.UserProperty)user.getProperty(EmailExtWatchAction.UserProperty.class)) == null) continue;
                ArrayListMultimap watcherTriggered = ArrayListMultimap.create();
                for (EmailTrigger trigger : prop.getTriggers()) {
                    if (trigger.isPreBuild() != forPreBuild || !trigger.trigger(build, (TaskListener)listener)) continue;
                    String tName = trigger.getDescriptor().getDisplayName();
                    watcherTriggered.put((Object)tName, (Object)trigger);
                    listener.getLogger().println("Email was triggered for watcher '" + user.getDisplayName() + "' for: " + tName);
                    emailTriggered = true;
                }
                replacedTriggers = new ArrayList();
                for (EmailTrigger tName : triggered.keySet()) {
                    String triggerName = (String)((Object)tName);
                    for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                        replacedTriggers.addAll(trigger.getDescriptor().getTriggerReplaceList());
                    }
                }
                for (String triggerName : replacedTriggers) {
                    watcherTriggered.removeAll((Object)triggerName);
                    listener.getLogger().println("Trigger " + triggerName + " was overridden by another trigger and will not send an email.");
                }
                triggered.putAll((Multimap)watcherTriggered);
            }
        }
        if (emailTriggered && triggered.isEmpty()) {
            listener.getLogger().println("There is a circular trigger replacement with the email triggers.  No email is sent.");
            return false;
        }
        if (triggered.isEmpty()) {
            listener.getLogger().println("No emails were triggered.");
            return true;
        }
        for (String triggerName : triggered.keySet()) {
            for (EmailTrigger trigger : triggered.get((Object)triggerName)) {
                listener.getLogger().println("Sending email for trigger: " + triggerName);
                ExtendedEmailPublisherContext context = new ExtendedEmailPublisherContext(this, (Run<?, ?>)build, build.getWorkspace(), launcher, (TaskListener)listener);
                context.setTriggered((Multimap<String, EmailTrigger>)triggered);
                context.setTrigger(trigger);
                this.sendMail(context);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    boolean sendMail(ExtendedEmailPublisherContext context) {
        try {
            InternetAddress fromAddress = this.getFromAddress();
            MailAccount mailAccount = this.getMailAccount(context);
            if (!mailAccount.isValid()) {
                if (!mailAccount.isFromAddressValid()) {
                    context.getListener().getLogger().println("Mail account has invalid from address");
                    if (mailAccount.isDefaultAccount()) {
                        this.debug(context.getListener().getLogger(), "Default account has invalid from address", new Object[0]);
                    } else {
                        this.debug(context.getListener().getLogger(), "Additional account has invalid from address " + mailAccount.getAddress(), new Object[0]);
                    }
                } else if (!mailAccount.isSmtpServerValid()) {
                    context.getListener().getLogger().println("Mail account has invalid SMTP server");
                    if (mailAccount.isDefaultAccount()) {
                        this.debug(context.getListener().getLogger(), "Default account has invalid SMTP server", new Object[0]);
                    } else {
                        this.debug(context.getListener().getLogger(), "Additional account " + mailAccount.getAddress() + " has invalid SMTP server", new Object[0]);
                    }
                } else if (!mailAccount.isSmtpAuthValid()) {
                    context.getListener().getLogger().println("Mail account has invalid SMTP authentication settings");
                    if (mailAccount.isDefaultAccount()) {
                        this.debug(context.getListener().getLogger(), "Default account has invalid SMTP authentication settings", new Object[0]);
                    } else {
                        this.debug(context.getListener().getLogger(), "Additional account " + mailAccount.getAddress() + " has invalid SMTP authentication settings", new Object[0]);
                    }
                }
                return false;
            }
            Session session = this.getDescriptor().createSession(mailAccount);
            if (session == null) {
                context.getListener().getLogger().println("Could not create session");
                return false;
            }
            MimeMessage msg = this.createMail(context, fromAddress, session);
            this.debug(context.getListener().getLogger(), "Successfully created MimeMessage", new Object[0]);
            Address[] allRecipients = msg.getAllRecipients();
            int retries = 0;
            if (this.executePresendScript(context, msg)) {
                allRecipients = msg.getAllRecipients();
                if (allRecipients != null) {
                    Transport transport;
                    block38: {
                        if (StringUtils.isNotBlank((String)this.getDescriptor().getEmergencyReroute())) {
                            msg.setRecipients(Message.RecipientType.TO, (Address[])null);
                            msg.setRecipients(Message.RecipientType.CC, (Address[])null);
                            msg.setRecipients(Message.RecipientType.BCC, (Address[])null);
                            msg.setRecipients(Message.RecipientType.TO, this.getDescriptor().getEmergencyReroute());
                        }
                        StringBuilder buf = new StringBuilder("Sending email to:");
                        for (Address address : allRecipients) {
                            buf.append(' ').append(address);
                        }
                        context.getListener().getLogger().println(buf);
                        allRecipients = msg.getAllRecipients();
                        transport = session.getTransport(allRecipients[0]);
                        do {
                            try {
                                transport.connect();
                                transport.sendMessage((Message)msg, allRecipients);
                                break block38;
                            }
                            catch (SendFailedException e) {
                                void var12_26;
                                if (e.getNextException() != null && (e.getNextException() instanceof SocketException || e.getNextException() instanceof ConnectException)) {
                                    context.getListener().getLogger().println("Socket error sending email, retrying once more in 10 seconds...");
                                    transport.close();
                                    Thread.sleep(10000L);
                                    continue;
                                }
                                Address[] addresses = e.getValidSentAddresses();
                                if (addresses != null && addresses.length > 0) {
                                    buf = new StringBuilder("Successfully sent to the following addresses:");
                                    for (Address a : addresses) {
                                        buf.append(' ').append(a);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                if ((addresses = e.getValidUnsentAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Not sent to the following valid addresses:");
                                    for (Address a : addresses) {
                                        buf.append(' ').append(a);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                if ((addresses = e.getInvalidAddresses()) != null && addresses.length > 0) {
                                    buf = new StringBuilder("Could not be sent to the following addresses:");
                                    for (Address a : addresses) {
                                        buf.append(' ').append(a);
                                    }
                                    context.getListener().getLogger().println(buf);
                                }
                                this.debug(context.getListener().getLogger(), ((Object)((Object)e)).getClass().getSimpleName() + " message: " + e.getMessage(), new Object[0]);
                                Exception exception = e.getNextException();
                                while (var12_26 != null) {
                                    this.debug(context.getListener().getLogger(), "Next " + var12_26.getClass().getSimpleName() + " message: " + var12_26.getMessage(), new Object[0]);
                                    if (var12_26 instanceof MessagingException) {
                                        Exception exception2 = ((MessagingException)var12_26).getNextException();
                                        continue;
                                    }
                                    Object var12_28 = null;
                                }
                                break block38;
                            }
                            catch (MessagingException e) {
                                if (e.getNextException() != null && e.getNextException() instanceof ConnectException) {
                                    context.getListener().getLogger().println("Connection error sending email, retrying once more in 10 seconds...");
                                    transport.close();
                                    Thread.sleep(10000L);
                                    continue;
                                }
                                this.debug(context.getListener().getLogger(), ((Object)((Object)e)).getClass().getSimpleName() + " message: " + e.getMessage(), new Object[0]);
                                Exception next = e.getNextException();
                                while (next != null) {
                                    this.debug(context.getListener().getLogger(), "Next " + next.getClass().getSimpleName() + " message: " + next.getMessage(), new Object[0]);
                                    if (next instanceof MessagingException) {
                                        next = ((MessagingException)((Object)next)).getNextException();
                                        continue;
                                    }
                                    next = null;
                                }
                                break block38;
                            }
                        } while (++retries <= 1);
                        context.getListener().getLogger().println("Failed after second try sending email");
                    }
                    this.executePostsendScript(context, msg, session, transport);
                    transport.close();
                    if (context.getRun().getAction(MailMessageIdAction.class) == null) {
                        context.getRun().addAction((Action)new MailMessageIdAction(msg.getMessageID()));
                    }
                } else {
                    context.getListener().getLogger().println("An attempt to send an e-mail to empty list of recipients, ignored.");
                }
            } else {
                context.getListener().getLogger().println("Email sending was cancelled by user script.");
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not send email.", e);
            Functions.printStackTrace((Throwable)e, (PrintWriter)context.getListener().error("Could not send email as a part of the post-build publishers."));
            this.debug(context.getListener().getLogger(), "Some error occurred trying to send the email...check the Jenkins log", new Object[0]);
            return false;
        }
    }

    public List<TokenMacro> getRuntimeMacros(ExtendedEmailPublisherContext context) {
        ArrayList<TokenMacro> macros = new ArrayList<TokenMacro>();
        macros.add(new TriggerNameContent(context.getTrigger().getDescriptor().getDisplayName()));
        return macros;
    }

    private boolean executePresendScript(ExtendedEmailPublisherContext context, MimeMessage msg) throws RuntimeException {
        return this.executeScript(this.presendScript, "pre-send", context, msg, null, null);
    }

    private void executePostsendScript(ExtendedEmailPublisherContext context, MimeMessage msg, Session session, Transport transport) throws RuntimeException {
        this.executeScript(this.postsendScript, "post-send", context, msg, session, transport);
    }

    private boolean executeScript(String rawScript, String scriptName, ExtendedEmailPublisherContext context, MimeMessage msg, Session session, Transport transport) {
        boolean cancel = false;
        String script = ContentBuilder.transformText(rawScript, context, this.getRuntimeMacros(context));
        if (StringUtils.isNotBlank((String)script)) {
            TaskListener listener = context.getListener();
            PrintStream logger = listener.getLogger();
            this.debug(logger, "Executing %s script", scriptName);
            Binding binding = new Binding();
            binding.setVariable("build", context.getBuild());
            binding.setVariable("run", context.getRun());
            binding.setVariable("msg", (Object)msg);
            Properties props = null;
            if (session != null) {
                props = session.getProperties();
                binding.setVariable("props", (Object)props);
            }
            if (transport != null) {
                binding.setVariable("transport", (Object)transport);
            }
            binding.setVariable("listener", (Object)listener);
            binding.setVariable("logger", (Object)logger);
            binding.setVariable("cancel", (Object)cancel);
            binding.setVariable("trigger", (Object)context.getTrigger());
            binding.setVariable("triggered", (Object)ImmutableMultimap.copyOf(context.getTriggered()));
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            try {
                ClassLoader cl = this.expandClasspath(context, Jenkins.get().getPluginManager().uberClassLoader);
                if (AbstractEvalContent.isApprovedScript(script, GroovyLanguage.get()) || !Jenkins.get().isUseSecurity()) {
                    GroovyShell shell = new GroovyShell(cl, binding, ExtendedEmailPublisher.getCompilerConfiguration(false));
                    shell.parse(script).run();
                    cancel = (Boolean)shell.getVariable("cancel");
                } else {
                    GroovyShell shell = new GroovyShell(cl, binding, ExtendedEmailPublisher.getCompilerConfiguration(true));
                    try {
                        new GroovySandbox().withWhitelist((Whitelist)new ProxyWhitelist(new Whitelist[]{Whitelist.all(), new MimeMessageInstanceWhitelist(msg), new PropertiesInstanceWhitelist(props), new TaskListenerInstanceWhitelist(listener), new PrintStreamInstanceWhitelist(logger), new EmailExtScriptTokenMacroWhitelist()})).runScript(shell, script);
                        cancel = (Boolean)shell.getVariable("cancel");
                    }
                    catch (RejectedAccessException x) {
                        throw ScriptApproval.get().accessRejected(x, ApprovalContext.create());
                    }
                }
                this.debug(logger, "%s script set cancel to %b", StringUtils.capitalize((String)scriptName), cancel);
            }
            catch (SecurityException e) {
                logger.println(StringUtils.capitalize((String)scriptName) + " script tried to access secured objects: " + e.getMessage());
                throw e;
            }
            catch (Throwable t) {
                Functions.printStackTrace((Throwable)t, (PrintWriter)pw);
                logger.println(out.toString());
            }
            this.debug(logger, out.toString(), new Object[0]);
        }
        return !cancel;
    }

    private static CompilerConfiguration getCompilerConfiguration(boolean sandbox) {
        CompilerConfiguration cc = sandbox ? GroovySandbox.createSecureCompilerConfiguration() : new CompilerConfiguration();
        cc.setScriptBaseClass(EmailExtScript.class.getCanonicalName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        return cc;
    }

    private ClassLoader expandClasspath(ExtendedEmailPublisherContext context, ClassLoader loader) throws IOException {
        List<GroovyScriptPath> globalClasspath;
        ArrayList<ClasspathEntry> classpathList = new ArrayList<ClasspathEntry>();
        if (this.classpath != null && !this.classpath.isEmpty()) {
            this.transformToClasspathEntries(this.classpath, context, classpathList);
        }
        if ((globalClasspath = this.getDescriptor().getDefaultClasspath()) != null && !globalClasspath.isEmpty()) {
            this.transformToClasspathEntries(globalClasspath, context, classpathList);
        }
        boolean useSecurity = Jenkins.get().isUseSecurity();
        if (!classpathList.isEmpty()) {
            GroovyClassLoader gloader = new GroovyClassLoader(loader);
            gloader.setShouldRecompile(Boolean.valueOf(true));
            for (ClasspathEntry entry : classpathList) {
                if (useSecurity) {
                    ScriptApproval.get().using(entry);
                }
                gloader.addURL(entry.getURL());
            }
            loader = gloader;
        }
        if (useSecurity) {
            return GroovySandbox.createSecureClassLoader((ClassLoader)loader);
        }
        return loader;
    }

    private void transformToClasspathEntries(List<GroovyScriptPath> input, ExtendedEmailPublisherContext context, List<ClasspathEntry> output) {
        for (GroovyScriptPath path : input) {
            URL url = path.asURL();
            if (url == null) continue;
            try {
                ClasspathEntry entry = new ClasspathEntry(url.toString());
                output.add(entry);
            }
            catch (MalformedURLException e) {
                context.getListener().getLogger().printf("[email-ext] Warning: Ignoring classpath: [%s] as it could not be transformed into a valid URL%n", path.getPath());
            }
        }
    }

    private void excludeNotAllowedDomains(ExtendedEmailPublisherContext context, Set<InternetAddress> to) {
        LinkedHashSet<InternetAddress> excludedRecipients = new LinkedHashSet<InternetAddress>();
        for (InternetAddress recipient : to) {
            if (EmailRecipientUtils.isAllowedDomain(recipient.getAddress(), context.getListener())) continue;
            excludedRecipients.add(recipient);
        }
        to.removeAll(excludedRecipients);
    }

    private InternetAddress getFromAddress() throws AddressException {
        ExtendedEmailPublisherDescriptor descriptor = this.getDescriptor();
        InternetAddress fromAddress = StringUtils.isBlank((String)this.from) ? new InternetAddress(descriptor.getAdminAddress()) : new InternetAddress(this.from);
        return fromAddress;
    }

    @Restricted(value={NoExternalUse.class})
    MailAccount getMailAccount(ExtendedEmailPublisherContext context) throws AddressException {
        ExtendedEmailPublisherDescriptor descriptor = this.getDescriptor();
        if (StringUtils.isBlank((String)this.from)) {
            this.debug(context.getListener().getLogger(), "Sending mail from default account using System Admin e-mail address", new Object[0]);
            return descriptor.getMailAccount();
        }
        InternetAddress fromAddress = new InternetAddress(this.from);
        for (MailAccount addAccount : descriptor.getAddAccounts()) {
            if (addAccount == null) continue;
            if (!addAccount.isValid()) {
                if (!addAccount.isFromAddressValid()) {
                    this.debug(context.getListener().getLogger(), "Ignoring additional account with invalid from address " + addAccount.getAddress(), new Object[0]);
                    continue;
                }
                if (!addAccount.isSmtpServerValid()) {
                    this.debug(context.getListener().getLogger(), "Ignoring additional account " + addAccount.getAddress() + " with invalid SMTP server", new Object[0]);
                    continue;
                }
                if (addAccount.isSmtpAuthValid()) continue;
                this.debug(context.getListener().getLogger(), "Ignoring additional account " + addAccount.getAddress() + " with invalid SMTP authentication", new Object[0]);
                continue;
            }
            if (!addAccount.getAddress().equalsIgnoreCase(fromAddress.getAddress())) {
                this.debug(context.getListener().getLogger(), "Ignoring valid additional account " + addAccount.getAddress() + " because it is not a match for " + this.from, new Object[0]);
                continue;
            }
            this.debug(context.getListener().getLogger(), "Sending mail from additional account " + addAccount.getAddress(), new Object[0]);
            return addAccount;
        }
        this.debug(context.getListener().getLogger(), "Sending mail from default account using custom from address " + this.from, new Object[0]);
        return descriptor.getMailAccount();
    }

    private MimeMessage createMail(ExtendedEmailPublisherContext context, InternetAddress fromAddress, Session session) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        String listId;
        MailMessageIdAction b;
        Run<?, ?> pb;
        Result result;
        ExtendedEmailPublisherDescriptor descriptor = this.getDescriptor();
        String charset = descriptor.getCharset();
        MimeMessage msg = new MimeMessage(session);
        if (fromAddress.getPersonal() != null) {
            fromAddress.setPersonal(fromAddress.getPersonal(), charset);
        }
        msg.setFrom((Address)fromAddress);
        if (descriptor.isDebugMode()) {
            session.setDebug(true);
            session.setDebugOut(context.getListener().getLogger());
        }
        msg.addHeader("X-Jenkins-Job", context.getRun().getParent().getDisplayName());
        Result result2 = result = context.getRun() != null ? context.getRun().getResult() : null;
        if (result != null) {
            msg.addHeader("X-Jenkins-Result", result.toString());
        }
        msg.setSentDate(new Date());
        this.setSubject(context, msg, charset);
        Multipart multipart = this.addContent(context, charset);
        AttachmentUtils attachments = new AttachmentUtils(this.attachmentsPattern);
        attachments.attach(multipart, context);
        if (StringUtils.isNotBlank((String)context.getTrigger().getEmail().getAttachmentsPattern())) {
            AttachmentUtils typeAttachments = new AttachmentUtils(context.getTrigger().getEmail().getAttachmentsPattern());
            typeAttachments.attach(multipart, context);
        }
        if (this.attachBuildLog || context.getTrigger().getEmail().getAttachBuildLog()) {
            this.debug(context.getListener().getLogger(), "Request made to attach build log", new Object[0]);
            AttachmentUtils.attachBuildLog(context, multipart, this.compressBuildLog || context.getTrigger().getEmail().getCompressBuildLog());
        }
        msg.setContent(multipart);
        EnvVars env = null;
        try {
            env = context.getRun().getEnvironment(context.getListener());
        }
        catch (Exception e) {
            context.getListener().getLogger().println("Error retrieving environment vars: " + e.getMessage());
            env = new EnvVars();
        }
        LinkedHashSet<InternetAddress> to = new LinkedHashSet<InternetAddress>();
        LinkedHashSet<InternetAddress> cc = new LinkedHashSet<InternetAddress>();
        LinkedHashSet<InternetAddress> bcc = new LinkedHashSet<InternetAddress>();
        String emergencyReroute = descriptor.getEmergencyReroute();
        if (StringUtils.isNotBlank((String)emergencyReroute)) {
            this.debug(context.getListener().getLogger(), "Emergency reroute turned on", new Object[0]);
            EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, emergencyReroute, env, context.getListener());
            this.debug(context.getListener().getLogger(), "Emergency reroute is set to: " + emergencyReroute, new Object[0]);
        } else {
            for (RecipientProvider recipientProvider : context.getTrigger().getEmail().getRecipientProviders()) {
                recipientProvider.addRecipients(context, env, to, cc, bcc);
            }
            descriptor.debug(context.getListener().getLogger(), "Adding recipients from trigger recipient list", new Object[0]);
            EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, EmailRecipientUtils.getRecipientList(context, context.getTrigger().getEmail().getRecipientList()), env, context.getListener());
        }
        LinkedHashSet<InternetAddress> excludedRecipients = new LinkedHashSet<InternetAddress>();
        for (InternetAddress recipient : to) {
            if (!EmailRecipientUtils.isExcludedRecipient(recipient.getAddress(), context.getListener())) continue;
            excludedRecipients.add(recipient);
        }
        to.removeAll(excludedRecipients);
        cc.removeAll(excludedRecipients);
        bcc.removeAll(excludedRecipients);
        this.excludeNotAllowedDomains(context, to);
        this.excludeNotAllowedDomains(context, cc);
        this.excludeNotAllowedDomains(context, bcc);
        msg.setRecipients(Message.RecipientType.TO, (Address[])to.toArray(new InternetAddress[0]));
        if (!cc.isEmpty()) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])cc.toArray(new InternetAddress[0]));
        }
        if (!bcc.isEmpty()) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])bcc.toArray(new InternetAddress[0]));
        }
        LinkedHashSet<InternetAddress> linkedHashSet = new LinkedHashSet<InternetAddress>();
        if (StringUtils.isNotBlank((String)this.replyTo)) {
            EmailRecipientUtils.addAddressesFromRecipientList(linkedHashSet, null, null, EmailRecipientUtils.getRecipientList(context, this.replyTo), env, context.getListener());
        }
        if (StringUtils.isNotBlank((String)context.getTrigger().getEmail().getReplyTo())) {
            EmailRecipientUtils.addAddressesFromRecipientList(linkedHashSet, null, null, EmailRecipientUtils.getRecipientList(context, context.getTrigger().getEmail().getReplyTo()), env, context.getListener());
        }
        if (!linkedHashSet.isEmpty()) {
            msg.setReplyTo((Address[])linkedHashSet.toArray(new InternetAddress[0]));
        }
        if ((pb = ExtendedEmailPublisher.getPreviousRun(context.getRun(), context.getListener())) != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null && pb.getResult() != Result.SUCCESS) {
            this.debug(context.getListener().getLogger(), "Setting In-Reply-To since last build was not successful", new Object[0]);
            msg.setHeader("In-Reply-To", b.messageId);
            msg.setHeader("References", b.messageId);
        }
        if (CONTENT_TRANSFER_ENCODING != null) {
            msg.setHeader("Content-Transfer-Encoding", CONTENT_TRANSFER_ENCODING);
        }
        if ((listId = descriptor.getListId()) != null) {
            msg.setHeader("List-ID", listId);
        }
        if (descriptor.getPrecedenceBulk()) {
            msg.setHeader("Precedence", "bulk");
        }
        return msg;
    }

    private void setSubject(ExtendedEmailPublisherContext context, MimeMessage msg, String charset) throws MessagingException {
        String subject = ContentBuilder.transformText(context.getTrigger().getEmail().getSubject(), context, this.getRuntimeMacros(context));
        msg.setSubject(subject, charset);
    }

    public boolean isExecuteOnMatrixNodes() {
        MatrixTriggerMode mtm = this.getMatrixTriggerMode();
        return MatrixTriggerMode.BOTH == mtm || MatrixTriggerMode.ONLY_CONFIGURATIONS == mtm;
    }

    private Multipart addContent(ExtendedEmailPublisherContext context, String charset) throws MessagingException {
        MimeMultipart multipart;
        String messageContentType;
        String text = ContentBuilder.transformText(context.getTrigger().getEmail().getBody(), context, this.getRuntimeMacros(context));
        boolean doBoth = false;
        String string = messageContentType = context.getTrigger().getEmail().getContentType().equals("project") ? this.contentType : context.getTrigger().getEmail().getContentType();
        if ((messageContentType == null || "default".equals(messageContentType)) && (messageContentType = this.getDescriptor().getDefaultContentType()) == null) {
            messageContentType = "text/plain";
        }
        if ("both".equals(messageContentType)) {
            doBoth = true;
            multipart = new MimeMultipart("alternative");
            messageContentType = "text/html";
        } else {
            multipart = new MimeMultipart();
        }
        messageContentType = messageContentType + "; charset=" + charset;
        try {
            if (this.saveOutput) {
                FilePath workspace;
                String extension = ".html";
                if (messageContentType.startsWith("text/plain")) {
                    extension = ".txt";
                }
                if ((workspace = context.getWorkspace()) != null) {
                    FilePath savedOutput = new FilePath(workspace, String.format("%s-%s%s", context.getTrigger().getDescriptor().getDisplayName(), context.getRun().getId(), extension));
                    savedOutput.write(text, charset);
                } else {
                    context.getListener().getLogger().println("No workspace to save the email to");
                }
            }
        }
        catch (IOException | InterruptedException e) {
            context.getListener().getLogger().println("Error trying to save email output to file. " + e.getMessage());
        }
        MimeBodyPart msgPart = new MimeBodyPart();
        this.debug(context.getListener().getLogger(), "messageContentType = %s", messageContentType);
        if (messageContentType.startsWith("text/html")) {
            CssInliner inliner = new CssInliner();
            if (doBoth) {
                MimeBodyPart plainTextPart = new MimeBodyPart();
                plainTextPart.setContent((Object)inliner.stripHtml(text), "text/plain; charset=" + charset);
                multipart.addBodyPart((BodyPart)plainTextPart);
            }
            String inlinedCssHtml = inliner.process(text);
            msgPart.setContent((Object)inlinedCssHtml, messageContentType);
        } else {
            msgPart.setContent((Object)text, messageContentType);
        }
        multipart.addBodyPart((BodyPart)msgPart);
        return multipart;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @CheckForNull
    public static Run<?, ?> getPreviousRun(@Nonnull Run<?, ?> run, TaskListener listener) {
        Run previousRun = run.getPreviousBuild();
        if (previousRun != null && previousRun.isBuilding()) {
            listener.getLogger().println(Messages.ExtendedEmailPublisher__is_still_in_progress_ignoring_for_purpo(previousRun.getDisplayName()));
            return null;
        }
        return previousRun;
    }

    public ExtendedEmailPublisherDescriptor getDescriptor() {
        return (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptor(((Object)((Object)this)).getClass());
    }

    public static ExtendedEmailPublisherDescriptor descriptor() {
        return (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
    }

    public MatrixAggregator createAggregator(MatrixBuild matrixbuild, Launcher launcher, BuildListener buildlistener) {
        return new MatrixAggregator(matrixbuild, launcher, buildlistener){

            public boolean endBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of {0}", this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.launcher, this.listener, false);
                }
                return true;
            }

            public boolean startBuild() throws InterruptedException, IOException {
                LOGGER.log(Level.FINER, "end build of {0}", this.build.getDisplayName());
                if (ExtendedEmailPublisher.this.getMatrixTriggerMode().forParent) {
                    return ExtendedEmailPublisher.this._perform((AbstractBuild)this.build, this.launcher, this.listener, true);
                }
                return true;
            }
        };
    }

    public Object readResolve() {
        if (!(!Jenkins.get().isUseSecurity() || StringUtils.isBlank((String)this.postsendScript) && StringUtils.isBlank((String)this.presendScript))) {
            this.setPostsendScript(this.postsendScript);
            this.setPresendScript(this.presendScript);
            this.setClasspath(this.classpath);
        }
        return this;
    }
}

