/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.RecipientListStringAnalyser;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class EmailRecipientUtils {
    private static final Logger LOGGER = Logger.getLogger(EmailRecipientUtils.class.getName());
    public static final int TO = 0;
    public static final int CC = 1;
    public static final int BCC = 2;

    public static Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars) throws AddressException, UnsupportedEncodingException {
        return EmailRecipientUtils.convertRecipientString(recipientList, envVars, 0, null);
    }

    public static Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars, int type) throws AddressException, UnsupportedEncodingException {
        return EmailRecipientUtils.convertRecipientString(recipientList, envVars, type, null);
    }

    private static Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars, int type, TaskListener listener) throws AddressException, UnsupportedEncodingException {
        LinkedHashSet<InternetAddress> internetAddresses = new LinkedHashSet<InternetAddress>();
        if (!StringUtils.isBlank((String)recipientList)) {
            String expandedRecipientList = EmailRecipientUtils.fixupDelimiters(envVars.expand(recipientList));
            RecipientListStringAnalyser recipientsAnalyser = RecipientListStringAnalyser.newInstance(listener, expandedRecipientList);
            InternetAddress[] all = InternetAddress.parse((String)expandedRecipientList.replace("bcc:", "").replace("cc:", ""));
            LinkedHashSet<InternetAddress> to = new LinkedHashSet<InternetAddress>();
            LinkedHashSet<InternetAddress> cc = new LinkedHashSet<InternetAddress>();
            LinkedHashSet<InternetAddress> bcc = new LinkedHashSet<InternetAddress>();
            String defaultSuffix = ExtendedEmailPublisher.descriptor().getDefaultSuffix();
            block5: for (InternetAddress address : all) {
                int typeForAddress = recipientsAnalyser.getType(address);
                switch (typeForAddress) {
                    case 2: {
                        bcc.add(address);
                        continue block5;
                    }
                    case 1: {
                        cc.add(address);
                        continue block5;
                    }
                    case -1: 
                    case 0: {
                        to.add(address);
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Got unsupported recipient type: " + typeForAddress);
                    }
                }
            }
            if (type == 2) {
                internetAddresses.addAll(bcc);
            } else if (type == 1) {
                internetAddresses.addAll(cc);
            } else {
                internetAddresses.addAll(to);
            }
            for (InternetAddress address : internetAddresses) {
                String userEmail;
                User u;
                if (!address.getAddress().contains("@") && (u = User.get((String)address.getAddress(), (boolean)false, Collections.emptyMap())) != null && (userEmail = EmailRecipientUtils.getUserConfiguredEmail(u)) != null) {
                    address.setAddress(userEmail);
                }
                if (!address.getAddress().contains("@") && defaultSuffix != null && defaultSuffix.contains("@")) {
                    address.setAddress(address.getAddress() + defaultSuffix);
                }
                if (address.getPersonal() == null) continue;
                address.setPersonal(address.getPersonal(), ExtendedEmailPublisher.descriptor().getCharset());
            }
        }
        return internetAddresses;
    }

    public static String getUserConfiguredEmail(User user) {
        Mailer.UserProperty mailProperty;
        String addr = null;
        if (user != null && (mailProperty = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)) != null) {
            addr = mailProperty.getAddress();
            String message = String.format("Resolved %s to %s", user.getId(), addr);
            LOGGER.fine(message);
        }
        return addr;
    }

    public FormValidation validateFormRecipientList(String recipientList) {
        try {
            EmailRecipientUtils.convertRecipientString(recipientList, new EnvVars(), 0);
            EmailRecipientUtils.convertRecipientString(recipientList, new EnvVars(), 2);
            EmailRecipientUtils.convertRecipientString(recipientList, new EnvVars(), 1);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)(e.getMessage() + ": \"" + e.getRef() + "\""));
        }
        catch (UnsupportedEncodingException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    private static String fixupDelimiters(String input) {
        input = input.trim();
        if ((input = input.replaceAll("\\s+", " ")).contains(" ") && !input.contains(",")) {
            input = input.replace(" ", ",");
        }
        input = input.replace(';', ',');
        return input;
    }

    public static boolean isAllowedDomain(String userName, TaskListener listener) {
        boolean result = true;
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        if (descriptor.getAllowedDomains() != null) {
            StringTokenizer tokens = new StringTokenizer(descriptor.getAllowedDomains(), ", ");
            boolean bl = result = !tokens.hasMoreTokens();
            while (tokens.hasMoreTokens()) {
                String check = tokens.nextToken().trim();
                descriptor.debug(listener.getLogger(), "Checking '%s' against '%s' to see if they are allowed", userName, check);
                if (!userName.endsWith(check)) continue;
                return true;
            }
        }
        return result;
    }

    public static boolean isExcludedRecipient(String userName, TaskListener listener) {
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        if (descriptor.getExcludedCommitters() != null) {
            StringTokenizer tokens = new StringTokenizer(descriptor.getExcludedCommitters(), ", ");
            while (tokens.hasMoreTokens()) {
                String check = tokens.nextToken().trim();
                descriptor.debug(listener.getLogger(), "Checking '%s' against '%s' to see if they are excluded", userName, check);
                if (!check.equalsIgnoreCase(userName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExcludedRecipient(User user, TaskListener listener) {
        String[] testValues;
        Mailer.UserProperty prop = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        for (String testValue : testValues = new String[]{user.getFullName(), user.getId(), user.getDisplayName(), prop != null ? prop.getAddress() : null}) {
            if (testValue == null || !EmailRecipientUtils.isExcludedRecipient(testValue, listener)) continue;
            return true;
        }
        return false;
    }

    public static void addAddressesFromRecipientList(Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, String recipientList, EnvVars envVars, TaskListener listener) {
        try {
            Set<InternetAddress> internetAddresses = EmailRecipientUtils.convertRecipientString(recipientList, envVars, 0, listener);
            to.addAll(internetAddresses);
            if (bcc != null) {
                Set<InternetAddress> bccInternetAddresses = EmailRecipientUtils.convertRecipientString(recipientList, envVars, 2, listener);
                bcc.addAll(bccInternetAddresses);
            }
            if (cc != null) {
                Set<InternetAddress> ccInternetAddresses = EmailRecipientUtils.convertRecipientString(recipientList, envVars, 1, listener);
                cc.addAll(ccInternetAddresses);
            }
        }
        catch (AddressException ae) {
            LOGGER.log(Level.WARNING, "Could not create email address.", ae);
            listener.getLogger().println("Failed to create e-mail address for " + ae.getRef());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.WARNING, "Could not create email address.", e);
            listener.getLogger().println("Failed to create e-mail address because of invalid encoding");
        }
    }

    public static String getRecipientList(ExtendedEmailPublisherContext context, String recipients) throws MessagingException {
        return StringUtils.isBlank((String)recipients) ? "" : ContentBuilder.transformText(recipients, context, context.getPublisher().getRuntimeMacros(context));
    }
}

