/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.GroovyScriptPath;
import hudson.plugins.emailext.MailAccount;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.FailureTrigger;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ReflectionUtils;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class ExtendedEmailPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    public static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisherDescriptor.class.getName());
    private String defaultSuffix;
    private transient String hudsonUrl;
    private MailAccount mailAccount;
    private List<MailAccount> addAccounts;
    private transient String adminAddress;
    private String charset;
    private String defaultContentType;
    private String defaultSubject;
    private String defaultBody;
    private String defaultPresendScript;
    private String defaultPostsendScript;
    private List<GroovyScriptPath> defaultClasspath;
    private transient List<EmailTriggerDescriptor> defaultTriggers;
    private List<String> defaultTriggerIds;
    private String emergencyReroute;
    private long maxAttachmentSize;
    private String recipientList;
    private String defaultReplyTo;
    private String allowedDomains;
    private String excludedCommitters;
    private boolean overrideGlobalSettings;
    private String listId;
    private boolean precedenceBulk;
    private boolean debugMode;
    private transient boolean enableSecurity;
    private boolean requireAdminForTemplateTesting;
    private boolean enableWatching;
    private boolean enableAllowUnregistered;
    private transient String smtpHost;
    private transient String smtpPort;
    private transient String smtpAuthUsername;
    private transient Secret smtpAuthPassword;
    private transient boolean useSsl;

    private Object readResolve() {
        if (this.smtpHost != null) {
            this.mailAccount.setSmtpHost(this.smtpHost);
        }
        if (this.smtpPort != null) {
            this.mailAccount.setSmtpPort(this.smtpPort);
        }
        if (this.smtpAuthUsername != null) {
            this.mailAccount.setSmtpUsername(this.smtpAuthUsername);
        }
        if (this.smtpAuthPassword != null) {
            this.mailAccount.setSmtpPassword(this.smtpAuthPassword);
        }
        if (this.useSsl) {
            this.mailAccount.setUseSsl(this.useSsl);
        }
        return this;
    }

    public ExtendedEmailPublisherDescriptor() {
        block9: {
            super(ExtendedEmailPublisher.class);
            this.mailAccount = new MailAccount();
            this.addAccounts = new ArrayList<MailAccount>();
            this.defaultPresendScript = "";
            this.defaultPostsendScript = "";
            this.defaultClasspath = new ArrayList<GroovyScriptPath>();
            this.defaultTriggers = new ArrayList<EmailTriggerDescriptor>();
            this.defaultTriggerIds = new ArrayList<String>();
            this.maxAttachmentSize = -1L;
            this.recipientList = "";
            this.defaultReplyTo = "";
            this.allowedDomains = null;
            this.excludedCommitters = "";
            this.debugMode = false;
            this.enableSecurity = false;
            this.requireAdminForTemplateTesting = false;
            this.useSsl = false;
            this.load();
            if (this.defaultBody == null && this.defaultSubject == null && this.emergencyReroute == null) {
                this.defaultBody = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
                this.defaultSubject = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
                this.emergencyReroute = "";
            }
            if (Jenkins.get().isUseSecurity() && !StringUtils.isBlank((String)this.defaultPostsendScript) || !StringUtils.isBlank((String)this.defaultPresendScript)) {
                this.setDefaultPostsendScript(this.defaultPostsendScript);
                this.setDefaultPresendScript(this.defaultPresendScript);
                try {
                    this.setDefaultClasspath(this.defaultClasspath);
                }
                catch (Descriptor.FormException e) {
                    ArrayList<GroovyScriptPath> newList = new ArrayList<GroovyScriptPath>();
                    for (GroovyScriptPath path : this.defaultClasspath) {
                        URL u = path.asURL();
                        if (u == null) continue;
                        try {
                            new ClasspathEntry(u.toString());
                            newList.add(path);
                        }
                        catch (MalformedURLException mfue) {
                            LOGGER.log(Level.WARNING, "The default classpath contained a malformed url, will be ignored.", mfue);
                        }
                    }
                    try {
                        this.setDefaultClasspath(newList);
                    }
                    catch (Descriptor.FormException e1) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError((Object)e1);
                    }
                }
            }
        }
    }

    public String getDisplayName() {
        return Messages.ExtendedEmailPublisherDescriptor_DisplayName();
    }

    public String getAdminAddress() {
        JenkinsLocationConfiguration configuration = JenkinsLocationConfiguration.get();
        assert (configuration != null);
        return configuration.getAdminAddress();
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(String defaultSuffix) {
        this.defaultSuffix = defaultSuffix;
    }

    public Session createSession(String from) throws MessagingException {
        Properties props = new Properties(System.getProperties());
        MailAccount acc = this.mailAccount;
        if (StringUtils.isNotBlank((String)from)) {
            InternetAddress fromAddress = new InternetAddress(from);
            for (MailAccount ma : this.addAccounts) {
                if (ma == null || !ma.isValid() || !ma.getAddress().equalsIgnoreCase(fromAddress.getAddress())) continue;
                acc = ma;
                break;
            }
        }
        if (acc.getSmtpHost() != null) {
            props.put("mail.smtp.host", acc.getSmtpHost());
        }
        if (acc.getSmtpPort() != null) {
            props.put("mail.smtp.port", acc.getSmtpPort());
        }
        if (acc.isUseSsl()) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                String port = acc.getSmtpPort() == null ? "465" : this.mailAccount.getSmtpPort();
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (acc.getSmtpUsername() != null) {
            props.put("mail.smtp.auth", "true");
        }
        props.put("mail.smtp.timeout", "60000");
        props.put("mail.smtp.connectiontimeout", "60000");
        try {
            String ap = acc.getAdvProperties();
            if (ap != null && !StringUtils.isBlank((String)ap.trim())) {
                props.load(new StringReader(ap));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Parameters parse fail.", e);
        }
        return Session.getInstance((Properties)props, (Authenticator)this.getAuthenticator(acc));
    }

    private Authenticator getAuthenticator(final MailAccount acc) {
        if (acc == null || acc.getSmtpUsername() == null) {
            return null;
        }
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(acc.getSmtpUsername(), Secret.toString((Secret)acc.getSmtpPassword()));
            }
        };
    }

    public String getHudsonUrl() {
        return Jenkins.get().getRootUrl();
    }

    public List<MailAccount> getAddAccounts() {
        return this.addAccounts;
    }

    public void setAddAccounts(List<MailAccount> addAccounts) {
        this.addAccounts = addAccounts;
    }

    public String getSmtpServer() {
        return this.mailAccount.getSmtpHost();
    }

    public void setSmtpServer(String smtpServer) {
        this.mailAccount.setSmtpHost(smtpServer);
    }

    public String getSmtpUsername() {
        return this.mailAccount.getSmtpUsername();
    }

    public void setSmtpUsername(String username) {
        this.mailAccount.setSmtpUsername(username);
    }

    public Secret getSmtpPassword() {
        return this.mailAccount.getSmtpPassword();
    }

    public void setSmtpPassword(String password) {
        this.mailAccount.setSmtpPassword(password);
    }

    public void setSmtpAuth(String userName, String password) {
        this.setSmtpUsername(userName);
        this.setSmtpPassword(password);
    }

    public boolean getUseSsl() {
        return this.mailAccount.isUseSsl();
    }

    public void setUseSsl(boolean useSsl) {
        this.mailAccount.setUseSsl(useSsl);
    }

    public String getSmtpPort() {
        return this.mailAccount.getSmtpPort();
    }

    public void setSmtpPort(String port) {
        this.mailAccount.setSmtpPort(this.nullify(port));
    }

    public String getAdvProperties() {
        return this.mailAccount.getAdvProperties();
    }

    public void setAdvProperties(String advProperties) {
        this.mailAccount.setAdvProperties(advProperties);
    }

    public String getCharset() {
        String c = this.charset;
        if (StringUtils.isBlank((String)c)) {
            c = "UTF-8";
        }
        return c;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(String contentType) {
        this.defaultContentType = StringUtils.isBlank((String)contentType) ? "text/plain" : contentType;
    }

    public String getDefaultSubject() {
        return this.defaultSubject;
    }

    public void setDefaultSubject(String subject) {
        this.defaultSubject = subject == null ? "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!" : subject;
    }

    public String getDefaultBody() {
        return this.defaultBody;
    }

    public void setDefaultBody(String body) {
        this.defaultBody = body == null ? "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results." : body;
    }

    public String getEmergencyReroute() {
        return this.emergencyReroute;
    }

    protected void setEmergencyReroute(String emergencyReroute) {
        this.emergencyReroute = emergencyReroute == null ? "" : emergencyReroute;
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public void setMaxAttachmentSize(long bytes) {
        if (bytes < 0L) {
            bytes = -1L;
        }
        this.maxAttachmentSize = bytes;
    }

    public long getMaxAttachmentSizeMb() {
        return this.maxAttachmentSize / 0x100000L;
    }

    public void setMaxAttachmentSizeMb(long mb) {
        this.setMaxAttachmentSize(mb * 0x100000L);
    }

    public String getDefaultRecipients() {
        return this.recipientList;
    }

    public void setDefaultRecipients(String recipients) {
        this.recipientList = recipients == null ? "" : recipients;
    }

    public String getAllowedDomains() {
        return this.allowedDomains;
    }

    public void setAllowedDomains(String allowed) {
        this.allowedDomains = allowed == null ? "" : allowed;
    }

    public String getExcludedCommitters() {
        return this.excludedCommitters;
    }

    public void setExcludedCommitters(String excluded) {
        this.excludedCommitters = excluded == null ? "" : excluded;
    }

    public boolean getOverrideGlobalSettings() {
        return this.overrideGlobalSettings;
    }

    public String getListId() {
        return this.listId;
    }

    public void setListId(String id) {
        this.listId = this.nullify(id);
    }

    public boolean getPrecedenceBulk() {
        return this.precedenceBulk;
    }

    public void setPrecedenceBulk(boolean bulk) {
        this.precedenceBulk = bulk;
    }

    public String getDefaultReplyTo() {
        return this.defaultReplyTo;
    }

    public void setDefaultReplyTo(String to) {
        this.defaultReplyTo = to == null ? "" : to;
    }

    public boolean isSecurityEnabled() {
        return false;
    }

    public boolean isAdminRequiredForTemplateTesting() {
        return this.requireAdminForTemplateTesting;
    }

    public void setAdminRequiredForTemplateTesting(boolean requireAdmin) {
        this.requireAdminForTemplateTesting = requireAdmin;
    }

    public boolean isWatchingEnabled() {
        return this.enableWatching;
    }

    public boolean isAllowUnregisteredEnabled() {
        return this.enableAllowUnregistered;
    }

    public void setWatchingEnabled(boolean enabled) {
        this.enableWatching = enabled;
    }

    public void setAllowUnregisteredEnabled(boolean enabled) {
        this.enableAllowUnregistered = enabled;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDefaultPresendScript() {
        return this.defaultPresendScript;
    }

    public void setDefaultPresendScript(String script) {
        script = StringUtils.trim((String)script);
        this.defaultPresendScript = ScriptApproval.get().configuring(script == null ? "" : script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public String getDefaultPostsendScript() {
        return this.defaultPostsendScript;
    }

    public void setDefaultPostsendScript(String script) {
        script = StringUtils.trim((String)script);
        this.defaultPostsendScript = ScriptApproval.get().configuring(script == null ? "" : script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public List<GroovyScriptPath> getDefaultClasspath() {
        return this.defaultClasspath;
    }

    public void setDefaultClasspath(List<GroovyScriptPath> defaultClasspath) throws Descriptor.FormException {
        if (Jenkins.get().isUseSecurity()) {
            ScriptApproval approval = ScriptApproval.get();
            ApprovalContext context = ApprovalContext.create().withCurrentUser();
            for (GroovyScriptPath path : defaultClasspath) {
                URL u = path.asURL();
                if (u == null) continue;
                try {
                    approval.configuring(new ClasspathEntry(u.toString()), context);
                }
                catch (MalformedURLException e) {
                    throw new Descriptor.FormException((Throwable)e, "ext_mailer_default_classpath");
                }
            }
        }
        this.defaultClasspath = defaultClasspath;
    }

    public List<String> getDefaultTriggerIds() {
        if (this.defaultTriggerIds.isEmpty()) {
            if (!this.defaultTriggers.isEmpty()) {
                this.defaultTriggerIds.clear();
                for (EmailTriggerDescriptor t : this.defaultTriggers) {
                    EmailTriggerDescriptor d = (EmailTriggerDescriptor)Jenkins.get().getDescriptorByType(((Object)((Object)t)).getClass());
                    if (d == null || this.defaultTriggerIds.contains(d.getId())) continue;
                    this.defaultTriggerIds.add(d.getId());
                }
            } else {
                FailureTrigger.DescriptorImpl f = (FailureTrigger.DescriptorImpl)Jenkins.get().getDescriptorByType(FailureTrigger.DescriptorImpl.class);
                if (f != null) {
                    this.defaultTriggerIds.add(f.getId());
                }
            }
            this.save();
        }
        return this.defaultTriggerIds;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.mailAccount.setSmtpHost(this.nullify(req.getParameter("ext_mailer_smtp_server")));
        this.defaultSuffix = this.nullify(req.getParameter("ext_mailer_default_suffix"));
        this.mailAccount.setAdvProperties(this.nullify(req.getParameter("ext_mailer_adv_properties")));
        this.addAccounts.clear();
        Object addacc = formData.opt("addAccounts");
        if (addacc != null) {
            MailAccount account;
            if (addacc instanceof JSONArray) {
                for (Object obj : (JSONArray)addacc) {
                    MailAccount account2 = new MailAccount((JSONObject)obj);
                    if (!account2.isValid()) continue;
                    this.addAccounts.add(account2);
                }
            } else if (addacc instanceof JSONObject && (account = new MailAccount((JSONObject)addacc)).isValid()) {
                this.addAccounts.add(account);
            }
        }
        if (req.hasParameter("ext_mailer_use_smtp_auth")) {
            this.mailAccount.setSmtpUsername(this.nullify(req.getParameter("ext_mailer_smtp_username")));
            this.mailAccount.setSmtpPassword(this.nullify(req.getParameter("ext_mailer_smtp_password")));
        } else {
            this.mailAccount.setSmtpUsername(null);
            this.mailAccount.setSmtpPassword((Secret)null);
        }
        this.mailAccount.setUseSsl(req.hasParameter("ext_mailer_smtp_use_ssl"));
        this.mailAccount.setSmtpPort(this.nullify(req.getParameter("ext_mailer_smtp_port")));
        this.charset = this.nullify(req.getParameter("ext_mailer_charset"));
        this.defaultContentType = this.nullify(req.getParameter("ext_mailer_default_content_type"));
        this.defaultSubject = this.nullify(req.getParameter("ext_mailer_default_subject"));
        this.defaultBody = this.nullify(req.getParameter("ext_mailer_default_body"));
        this.emergencyReroute = this.nullify(req.getParameter("ext_mailer_emergency_reroute"));
        this.defaultReplyTo = this.nullify(req.getParameter("ext_mailer_default_replyto")) != null ? req.getParameter("ext_mailer_default_replyto") : "";
        this.setDefaultPresendScript(this.nullify(req.getParameter("ext_mailer_default_presend_script")) != null ? req.getParameter("ext_mailer_default_presend_script") : "");
        this.setDefaultPostsendScript(this.nullify(req.getParameter("ext_mailer_default_postsend_script")) != null ? req.getParameter("ext_mailer_default_postsend_script") : "");
        if (req.hasParameter("ext_mailer_default_classpath")) {
            ArrayList<GroovyScriptPath> cp = new ArrayList<GroovyScriptPath>();
            for (String s : req.getParameterValues("ext_mailer_default_classpath")) {
                cp.add(new GroovyScriptPath(s));
            }
            this.setDefaultClasspath(cp);
        }
        this.debugMode = req.hasParameter("ext_mailer_debug_mode");
        this.maxAttachmentSize = this.nullify(req.getParameter("ext_mailer_max_attachment_size")) != null ? Long.parseLong(req.getParameter("ext_mailer_max_attachment_size")) * 1024L * 1024L : -1L;
        this.recipientList = this.nullify(req.getParameter("ext_mailer_default_recipients")) != null ? req.getParameter("ext_mailer_default_recipients") : "";
        this.precedenceBulk = req.hasParameter("ext_mailer_add_precedence_bulk");
        this.allowedDomains = req.getParameter("ext_mailer_allowed_domains");
        this.excludedCommitters = req.getParameter("ext_mailer_excluded_committers");
        this.requireAdminForTemplateTesting = req.hasParameter("ext_mailer_require_admin_for_template_testing");
        this.enableWatching = req.hasParameter("ext_mailer_watching_enabled");
        this.enableAllowUnregistered = req.hasParameter("ext_mailer_allow_unregistered_enabled");
        this.listId = req.hasParameter("ext_mailer_use_list_id") ? this.nullify(req.getParameter("ext_mailer_list_id")) : null;
        ArrayList<String> ids = new ArrayList<String>();
        if (formData.optJSONArray("defaultTriggers") != null) {
            for (Object id : formData.getJSONArray("defaultTriggers")) {
                ids.add(id.toString());
            }
        } else if (StringUtils.isNotEmpty((String)formData.optString("defaultTriggers"))) {
            ids.add(formData.getString("defaultTriggers"));
        }
        if (!ids.isEmpty()) {
            this.defaultTriggerIds.clear();
            for (String id : ids) {
                EmailTriggerDescriptor d = (EmailTriggerDescriptor)Jenkins.get().getDescriptor(id);
                if (d == null) continue;
                this.defaultTriggerIds.add(id);
            }
        }
        if (!this.overrideGlobalSettings) {
            this.upgradeFromMailer();
        }
        this.save();
        return super.configure(req, formData);
    }

    private String nullify(String v) {
        if (v != null && v.length() == 0) {
            v = null;
        }
        return v;
    }

    void upgradeFromMailer() {
        this.defaultSuffix = Mailer.descriptor().getDefaultSuffix();
        this.defaultReplyTo = Mailer.descriptor().getReplyToAddress();
        this.mailAccount.setUseSsl(Mailer.descriptor().getUseSsl());
        if (StringUtils.isNotBlank((String)Mailer.descriptor().getSmtpAuthUserName())) {
            this.mailAccount.setSmtpUsername(Mailer.descriptor().getSmtpAuthUserName());
            this.mailAccount.setSmtpPassword(Mailer.descriptor().getSmtpAuthPassword());
        }
        this.mailAccount.setSmtpHost(Mailer.descriptor().getSmtpServer());
        this.mailAccount.setSmtpPort(Mailer.descriptor().getSmtpPort());
        this.charset = Mailer.descriptor().getCharset();
        this.overrideGlobalSettings = true;
    }

    public String getHelpFile() {
        return "/plugin/email-ext/help/main.html";
    }

    public FormValidation doAddressCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            new InternetAddress(value);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public FormValidation doRecipientListRecipientsCheck(@QueryParameter String value) throws IOException, ServletException {
        return new EmailRecipientUtils().validateFormRecipientList(value);
    }

    public FormValidation doMaxAttachmentSizeCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            String testValue = value.trim();
            if (testValue.length() > 0) {
                Long.parseLong(testValue);
            }
            return FormValidation.ok();
        }
        catch (Exception e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public boolean isMatrixProject(Object project) {
        return project instanceof MatrixProject;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void debug(PrintStream logger, String format, Object ... args) {
        if (this.debugMode) {
            logger.format(format, args);
            logger.println();
        }
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return this.getJenkinsManageOrAdmin();
    }

    Permission getJenkinsManageOrAdmin() {
        Permission manage;
        try {
            manage = (Permission)ReflectionUtils.getPublicProperty((Object)Jenkins.get(), (String)"MANAGE");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            manage = Jenkins.ADMINISTER;
        }
        return manage;
    }
}

