/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.ListRecipientProvider;
import hudson.plugins.emailext.plugins.trigger.AlwaysTrigger;
import java.util.List;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class EmailExtStep
extends AbstractStepImpl {
    public final String subject;
    public final String body;
    @CheckForNull
    private String attachmentsPattern;
    @CheckForNull
    private String to;
    @CheckForNull
    private String replyTo;
    @CheckForNull
    private String from;
    @CheckForNull
    private String mimeType;
    private boolean attachLog;
    private boolean compressLog;
    private List<RecipientProvider> recipientProviders;
    private String presendScript;
    private String postsendScript;
    private boolean saveOutput;

    @DataBoundConstructor
    public EmailExtStep(String subject, String body) {
        this.subject = subject;
        this.body = body;
    }

    @CheckForNull
    public String getAttachmentsPattern() {
        return this.attachmentsPattern == null ? "" : this.attachmentsPattern;
    }

    @DataBoundSetter
    public void setAttachmentsPattern(@CheckForNull String attachmentsPattern) {
        if (StringUtils.isNotBlank((String)attachmentsPattern)) {
            this.attachmentsPattern = attachmentsPattern;
        }
    }

    @CheckForNull
    public String getTo() {
        return this.to == null ? "" : this.to;
    }

    @DataBoundSetter
    public void setTo(@CheckForNull String to) {
        this.to = Util.fixNull((String)to);
    }

    @CheckForNull
    public String getFrom() {
        return this.from == null ? "" : this.from;
    }

    @DataBoundSetter
    public void setFrom(@CheckForNull String from) {
        this.from = Util.fixNull((String)from);
    }

    @CheckForNull
    public String getReplyTo() {
        return this.replyTo == null ? "" : this.replyTo;
    }

    @DataBoundSetter
    public void setReplyTo(@CheckForNull String replyTo) {
        this.replyTo = Util.fixNull((String)replyTo);
    }

    @CheckForNull
    public String getMimeType() {
        return this.mimeType == null ? "" : this.mimeType;
    }

    @DataBoundSetter
    public void setMimeType(@CheckForNull String mimeType) {
        this.mimeType = Util.fixNull((String)mimeType);
    }

    public boolean getAttachLog() {
        return this.attachLog;
    }

    @DataBoundSetter
    public void setAttachLog(boolean attachLog) {
        this.attachLog = attachLog;
    }

    public boolean getCompressLog() {
        return this.compressLog;
    }

    @DataBoundSetter
    public void setCompressLog(boolean compressLog) {
        this.compressLog = compressLog;
    }

    @DataBoundSetter
    public void setRecipientProviders(List<RecipientProvider> recipientProviders) {
        this.recipientProviders = recipientProviders;
    }

    public List<? extends RecipientProvider> getRecipientProviders() {
        return this.recipientProviders;
    }

    @DataBoundSetter
    public void setPresendScript(String presendScript) {
        this.presendScript = presendScript;
    }

    public String getPresendScript() {
        return this.presendScript == null ? "" : this.presendScript;
    }

    @DataBoundSetter
    public void setPostsendScript(String postsendScript) {
        this.postsendScript = postsendScript;
    }

    public String getPostsendScript() {
        return this.postsendScript == null ? "" : this.postsendScript;
    }

    public boolean getSaveOutput() {
        return this.saveOutput;
    }

    @DataBoundSetter
    public void setSaveOutput(boolean saveOutput) {
        this.saveOutput = saveOutput;
    }

    @Extension(optional=true)
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final String defaultMimeType = "text/plain";

        public DescriptorImpl() {
            super(EmailExtStepExecution.class);
        }

        public String getFunctionName() {
            return "emailext";
        }

        public String getDisplayName() {
            return "Extended Email";
        }

        public List<RecipientProviderDescriptor> getRecipientProvidersDescriptors() {
            return RecipientProvider.allSupporting(WorkflowJob.class);
        }
    }

    public static class EmailExtStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient EmailExtStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run<?, ?> run;

        protected Void run() throws Exception {
            ExtendedEmailPublisher publisher = new ExtendedEmailPublisher();
            publisher.configuredTriggers.clear();
            AlwaysTrigger.DescriptorImpl descriptor = (AlwaysTrigger.DescriptorImpl)Jenkins.get().getDescriptorByType(AlwaysTrigger.DescriptorImpl.class);
            EmailTrigger trigger = descriptor.createDefault();
            trigger.getEmail().getRecipientProviders().clear();
            trigger.getEmail().addRecipientProvider(new ListRecipientProvider());
            if (this.step.recipientProviders != null) {
                RecipientProvider.checkAllSupport(this.step.recipientProviders, this.run.getParent().getClass());
                trigger.getEmail().addRecipientProviders(this.step.recipientProviders);
            }
            publisher.configuredTriggers.add(trigger);
            publisher.saveOutput = this.step.saveOutput;
            publisher.defaultSubject = this.step.subject;
            publisher.defaultContent = this.step.body;
            publisher.attachBuildLog = this.step.attachLog;
            publisher.compressBuildLog = this.step.compressLog;
            publisher.setPresendScript(this.step.presendScript);
            publisher.setPostsendScript(this.step.postsendScript);
            if (StringUtils.isNotBlank((String)this.step.to)) {
                publisher.recipientList = this.step.to;
            }
            if (StringUtils.isNotBlank((String)this.step.replyTo)) {
                publisher.replyTo = this.step.replyTo;
            }
            if (StringUtils.isNotBlank((String)this.step.from)) {
                publisher.from = this.step.from;
            }
            if (StringUtils.isNotBlank((String)this.step.attachmentsPattern)) {
                publisher.attachmentsPattern = this.step.attachmentsPattern;
            }
            if (StringUtils.isNotBlank((String)this.step.mimeType)) {
                publisher.contentType = this.step.mimeType;
            }
            ExtendedEmailPublisherContext ctx = new ExtendedEmailPublisherContext(publisher, this.run, (FilePath)this.getContext().get(FilePath.class), (Launcher)this.getContext().get(Launcher.class), this.listener);
            ArrayListMultimap triggered = ArrayListMultimap.create();
            triggered.put((Object)"Always", (Object)publisher.configuredTriggers.get(0));
            ctx.setTrigger(publisher.configuredTriggers.get(0));
            ctx.setTriggered((Multimap<String, EmailTrigger>)triggered);
            publisher.sendMail(ctx);
            return null;
        }
    }
}

