/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.DataBoundConstructor;

public class CulpritsRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public CulpritsRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getActiveInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        Run run = context.getRun();
        boolean runHasGetCulprits = false;
        try {
            Set users;
            Method getCulprits = run.getClass().getMethod("getCulprits", new Class[0]);
            runHasGetCulprits = true;
            if (Set.class.isAssignableFrom(getCulprits.getReturnType()) && Iterables.all((Iterable)(users = (Set)getCulprits.invoke(run, new Object[0])), (Predicate)Predicates.instanceOf(User.class))) {
                RecipientProviderUtilities.addUsers((Set<User>)users, context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (!(run instanceof WorkflowRun) || runHasGetCulprits) {
                debug.send("Exception getting culprits for %s: %s", run, e);
            }
            ArrayList builds = new ArrayList();
            Run build = run;
            builds.add(build);
            for (build = build.getPreviousCompletedBuild(); build != null; build = build.getPreviousCompletedBuild()) {
                Result buildResult = build.getResult();
                if (buildResult == null) continue;
                if (!buildResult.isWorseThan(Result.SUCCESS)) break;
                debug.send("Including build %s with status %s", build.getId(), buildResult);
                builds.add(build);
            }
            Set<User> users = RecipientProviderUtilities.getChangeSetAuthors(builds, debug);
            RecipientProviderUtilities.addUsers(users, context, env, to, cc, bcc, (RecipientProviderUtilities.IDebug)debug);
        }
    }

    @Extension
    @Symbol(value={"culprits"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        public String getDisplayName() {
            return "Culprits";
        }
    }
}

