/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.Extension;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.GroovyScriptPath;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.FailureTrigger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public final class ExtendedEmailPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    public static final Logger LOGGER = Logger.getLogger(ExtendedEmailPublisherDescriptor.class.getName());
    private String defaultSuffix;
    private transient String hudsonUrl;
    private String smtpAuthUsername;
    private Secret smtpAuthPassword;
    private transient String adminAddress;
    private String smtpHost;
    private boolean useSsl;
    private String smtpPort;
    private String charset;
    private String defaultContentType;
    private String defaultSubject;
    private String defaultBody;
    private String defaultPresendScript;
    private String defaultPostsendScript;
    private List<GroovyScriptPath> defaultClasspath;
    private transient List<EmailTriggerDescriptor> defaultTriggers;
    private List<String> defaultTriggerIds;
    private String emergencyReroute;
    private long maxAttachmentSize;
    private String recipientList;
    private String defaultReplyTo;
    private String excludedCommitters;
    private boolean overrideGlobalSettings;
    private String listId;
    private boolean precedenceBulk;
    private boolean debugMode;
    private transient boolean enableSecurity;
    private boolean requireAdminForTemplateTesting;
    private boolean enableWatching;
    private boolean enableAllowUnregistered;

    public ExtendedEmailPublisherDescriptor() {
        block9: {
            super(ExtendedEmailPublisher.class);
            this.defaultPresendScript = "";
            this.defaultPostsendScript = "";
            this.defaultClasspath = new ArrayList<GroovyScriptPath>();
            this.defaultTriggers = new ArrayList<EmailTriggerDescriptor>();
            this.defaultTriggerIds = new ArrayList<String>();
            this.maxAttachmentSize = -1L;
            this.recipientList = "";
            this.defaultReplyTo = "";
            this.excludedCommitters = "";
            this.debugMode = false;
            this.enableSecurity = false;
            this.requireAdminForTemplateTesting = false;
            this.load();
            if (this.defaultBody == null && this.defaultSubject == null && this.emergencyReroute == null) {
                this.defaultBody = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results.";
                this.defaultSubject = "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!";
                this.emergencyReroute = "";
            }
            if (Jenkins.getActiveInstance().isUseSecurity() && !StringUtils.isBlank((String)this.defaultPostsendScript) || !StringUtils.isBlank((String)this.defaultPresendScript)) {
                this.setDefaultPostsendScript(this.defaultPostsendScript);
                this.setDefaultPresendScript(this.defaultPresendScript);
                try {
                    this.setDefaultClasspath(this.defaultClasspath);
                }
                catch (Descriptor.FormException e) {
                    ArrayList<GroovyScriptPath> newList = new ArrayList<GroovyScriptPath>();
                    for (GroovyScriptPath path : this.defaultClasspath) {
                        URL u = path.asURL();
                        if (u == null) continue;
                        try {
                            new ClasspathEntry(u.toString());
                            newList.add(path);
                        }
                        catch (MalformedURLException mfue) {
                            LOGGER.log(Level.WARNING, "The default classpath contained a malformed url, will be ignored.", mfue);
                        }
                    }
                    try {
                        this.setDefaultClasspath(newList);
                    }
                    catch (Descriptor.FormException e1) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError((Object)e1);
                    }
                }
            }
        }
    }

    public String getDisplayName() {
        return Messages.ExtendedEmailPublisherDescriptor_DisplayName();
    }

    public String getAdminAddress() {
        JenkinsLocationConfiguration configuration = JenkinsLocationConfiguration.get();
        assert (configuration != null);
        return configuration.getAdminAddress();
    }

    public String getDefaultSuffix() {
        return this.defaultSuffix;
    }

    public void setDefaultSuffix(String defaultSuffix) {
        this.defaultSuffix = defaultSuffix;
    }

    public Session createSession() {
        Properties props = new Properties(System.getProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        if (this.smtpPort != null) {
            props.put("mail.smtp.port", this.smtpPort);
        }
        if (this.useSsl) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                String port = this.smtpPort == null ? "465" : this.smtpPort;
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            if (props.getProperty("mail.smtp.socketFactory.class") == null) {
                props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
        }
        if (this.smtpAuthUsername != null) {
            props.put("mail.smtp.auth", "true");
        }
        props.put("mail.smtp.timeout", "60000");
        props.put("mail.smtp.connectiontimeout", "60000");
        return Session.getInstance((Properties)props, (Authenticator)this.getAuthenticator());
    }

    private Authenticator getAuthenticator() {
        String un = this.getSmtpAuthUsername();
        if (un == null) {
            return null;
        }
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(ExtendedEmailPublisherDescriptor.this.getSmtpAuthUsername(), ExtendedEmailPublisherDescriptor.this.getSmtpAuthPassword());
            }
        };
    }

    public String getHudsonUrl() {
        return Jenkins.getActiveInstance().getRootUrl();
    }

    public String getSmtpServer() {
        return this.smtpHost;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpHost = smtpServer;
    }

    public String getSmtpAuthUsername() {
        return this.smtpAuthUsername;
    }

    public void setSmtpAuthUsername(String username) {
        this.smtpAuthUsername = username;
    }

    public String getSmtpAuthPassword() {
        return Secret.toString((Secret)this.smtpAuthPassword);
    }

    public void setSmtpAuthPassword(String password) {
        this.smtpAuthPassword = Secret.fromString((String)password);
    }

    public void setSmtpAuth(String userName, String password) {
        this.setSmtpAuthUsername(userName);
        this.setSmtpAuthPassword(password);
    }

    public boolean getUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public String getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(String port) {
        this.smtpPort = this.nullify(port);
    }

    public String getCharset() {
        String c = this.charset;
        if (StringUtils.isBlank((String)c)) {
            c = "UTF-8";
        }
        return c;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(String contentType) {
        this.defaultContentType = StringUtils.isBlank((String)contentType) ? "text/plain" : contentType;
    }

    public String getDefaultSubject() {
        return this.defaultSubject;
    }

    public void setDefaultSubject(String subject) {
        this.defaultSubject = subject == null ? "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS!" : subject;
    }

    public String getDefaultBody() {
        return this.defaultBody;
    }

    public void setDefaultBody(String body) {
        this.defaultBody = body == null ? "$PROJECT_NAME - Build # $BUILD_NUMBER - $BUILD_STATUS:\n\nCheck console output at $BUILD_URL to view the results." : body;
    }

    public String getEmergencyReroute() {
        return this.emergencyReroute;
    }

    protected void setEmergencyReroute(String emergencyReroute) {
        this.emergencyReroute = emergencyReroute == null ? "" : emergencyReroute;
    }

    public long getMaxAttachmentSize() {
        return this.maxAttachmentSize;
    }

    public void setMaxAttachmentSize(long bytes) {
        if (bytes < 0L) {
            bytes = -1L;
        }
        this.maxAttachmentSize = bytes;
    }

    public long getMaxAttachmentSizeMb() {
        return this.maxAttachmentSize / 0x100000L;
    }

    public void setMaxAttachmentSizeMb(long mb) {
        this.setMaxAttachmentSize(mb * 0x100000L);
    }

    public String getDefaultRecipients() {
        return this.recipientList;
    }

    public void setDefaultRecipients(String recipients) {
        this.recipientList = recipients == null ? "" : recipients;
    }

    public String getExcludedCommitters() {
        return this.excludedCommitters;
    }

    public void setExcludedCommitters(String excluded) {
        this.excludedCommitters = excluded == null ? "" : excluded;
    }

    public boolean getOverrideGlobalSettings() {
        return this.overrideGlobalSettings;
    }

    public String getListId() {
        return this.listId;
    }

    public void setListId(String id) {
        this.listId = this.nullify(id);
    }

    public boolean getPrecedenceBulk() {
        return this.precedenceBulk;
    }

    public void setPrecedenceBulk(boolean bulk) {
        this.precedenceBulk = bulk;
    }

    public String getDefaultReplyTo() {
        return this.defaultReplyTo;
    }

    public void setDefaultReplyTo(String to) {
        this.defaultReplyTo = to == null ? "" : to;
    }

    public boolean isSecurityEnabled() {
        return false;
    }

    public boolean isAdminRequiredForTemplateTesting() {
        return this.requireAdminForTemplateTesting;
    }

    public void setAdminRequiredForTemplateTesting(boolean requireAdmin) {
        this.requireAdminForTemplateTesting = requireAdmin;
    }

    public boolean isWatchingEnabled() {
        return this.enableWatching;
    }

    public boolean isAllowUnregisteredEnabled() {
        return this.enableAllowUnregistered;
    }

    public void setWatchingEnabled(boolean enabled) {
        this.enableWatching = enabled;
    }

    public void setAllowUnregisteredEnabled(boolean enabled) {
        this.enableAllowUnregistered = enabled;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public String getDefaultPresendScript() {
        return this.defaultPresendScript;
    }

    public void setDefaultPresendScript(String script) {
        script = StringUtils.trim((String)script);
        this.defaultPresendScript = ScriptApproval.get().configuring(script == null ? "" : script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public String getDefaultPostsendScript() {
        return this.defaultPostsendScript;
    }

    public void setDefaultPostsendScript(String script) {
        script = StringUtils.trim((String)script);
        this.defaultPostsendScript = ScriptApproval.get().configuring(script == null ? "" : script, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public List<GroovyScriptPath> getDefaultClasspath() {
        return this.defaultClasspath;
    }

    public void setDefaultClasspath(List<GroovyScriptPath> defaultClasspath) throws Descriptor.FormException {
        if (Jenkins.getActiveInstance().isUseSecurity()) {
            ScriptApproval approval = ScriptApproval.get();
            ApprovalContext context = ApprovalContext.create().withCurrentUser();
            for (GroovyScriptPath path : defaultClasspath) {
                URL u = path.asURL();
                if (u == null) continue;
                try {
                    approval.configuring(new ClasspathEntry(u.toString()), context);
                }
                catch (MalformedURLException e) {
                    throw new Descriptor.FormException((Throwable)e, "ext_mailer_default_classpath");
                }
            }
        }
        this.defaultClasspath = defaultClasspath;
    }

    public List<String> getDefaultTriggerIds() {
        if (this.defaultTriggerIds.isEmpty()) {
            if (!this.defaultTriggers.isEmpty()) {
                this.defaultTriggerIds.clear();
                for (EmailTriggerDescriptor t : this.defaultTriggers) {
                    EmailTriggerDescriptor d = (EmailTriggerDescriptor)Jenkins.getActiveInstance().getDescriptorByType(((Object)((Object)t)).getClass());
                    if (d == null || this.defaultTriggerIds.contains(d.getId())) continue;
                    this.defaultTriggerIds.add(d.getId());
                }
            } else {
                FailureTrigger.DescriptorImpl f = (FailureTrigger.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(FailureTrigger.DescriptorImpl.class);
                if (f != null) {
                    this.defaultTriggerIds.add(f.getId());
                }
            }
            this.save();
        }
        return this.defaultTriggerIds;
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        this.smtpHost = this.nullify(req.getParameter("ext_mailer_smtp_server"));
        this.defaultSuffix = this.nullify(req.getParameter("ext_mailer_default_suffix"));
        if (req.hasParameter("ext_mailer_use_smtp_auth")) {
            this.smtpAuthUsername = this.nullify(req.getParameter("ext_mailer_smtp_username"));
            this.smtpAuthPassword = Secret.fromString((String)this.nullify(req.getParameter("ext_mailer_smtp_password")));
        } else {
            this.smtpAuthUsername = null;
            this.smtpAuthPassword = null;
        }
        this.useSsl = req.hasParameter("ext_mailer_smtp_use_ssl");
        this.smtpPort = this.nullify(req.getParameter("ext_mailer_smtp_port"));
        this.charset = this.nullify(req.getParameter("ext_mailer_charset"));
        this.defaultContentType = this.nullify(req.getParameter("ext_mailer_default_content_type"));
        this.defaultSubject = this.nullify(req.getParameter("ext_mailer_default_subject"));
        this.defaultBody = this.nullify(req.getParameter("ext_mailer_default_body"));
        this.emergencyReroute = this.nullify(req.getParameter("ext_mailer_emergency_reroute"));
        this.defaultReplyTo = this.nullify(req.getParameter("ext_mailer_default_replyto")) != null ? req.getParameter("ext_mailer_default_replyto") : "";
        this.setDefaultPresendScript(this.nullify(req.getParameter("ext_mailer_default_presend_script")) != null ? req.getParameter("ext_mailer_default_presend_script") : "");
        this.setDefaultPostsendScript(this.nullify(req.getParameter("ext_mailer_default_postsend_script")) != null ? req.getParameter("ext_mailer_default_postsend_script") : "");
        if (req.hasParameter("ext_mailer_default_classpath")) {
            ArrayList<GroovyScriptPath> cp = new ArrayList<GroovyScriptPath>();
            for (String s : req.getParameterValues("ext_mailer_default_classpath")) {
                cp.add(new GroovyScriptPath(s));
            }
            this.setDefaultClasspath(cp);
        }
        this.debugMode = req.hasParameter("ext_mailer_debug_mode");
        this.maxAttachmentSize = this.nullify(req.getParameter("ext_mailer_max_attachment_size")) != null ? Long.parseLong(req.getParameter("ext_mailer_max_attachment_size")) * 1024L * 1024L : -1L;
        this.recipientList = this.nullify(req.getParameter("ext_mailer_default_recipients")) != null ? req.getParameter("ext_mailer_default_recipients") : "";
        this.precedenceBulk = req.hasParameter("ext_mailer_add_precedence_bulk");
        this.excludedCommitters = req.getParameter("ext_mailer_excluded_committers");
        this.requireAdminForTemplateTesting = req.hasParameter("ext_mailer_require_admin_for_template_testing");
        this.enableWatching = req.hasParameter("ext_mailer_watching_enabled");
        this.enableAllowUnregistered = req.hasParameter("ext_mailer_allow_unregistered_enabled");
        this.listId = req.hasParameter("ext_mailer_use_list_id") ? this.nullify(req.getParameter("ext_mailer_list_id")) : null;
        ArrayList<String> ids = new ArrayList<String>();
        if (formData.optJSONArray("defaultTriggers") != null) {
            for (Object id : formData.getJSONArray("defaultTriggers")) {
                ids.add(id.toString());
            }
        } else if (StringUtils.isNotEmpty((String)formData.optString("defaultTriggers"))) {
            ids.add(formData.getString("defaultTriggers"));
        }
        if (!ids.isEmpty()) {
            this.defaultTriggerIds.clear();
            for (String id : ids) {
                EmailTriggerDescriptor d = (EmailTriggerDescriptor)Jenkins.getActiveInstance().getDescriptor(id);
                if (d == null) continue;
                this.defaultTriggerIds.add(id);
            }
        }
        if (!this.overrideGlobalSettings) {
            this.upgradeFromMailer();
        }
        this.save();
        return super.configure(req, formData);
    }

    private String nullify(String v) {
        if (v != null && v.length() == 0) {
            v = null;
        }
        return v;
    }

    void upgradeFromMailer() {
        this.defaultSuffix = Mailer.descriptor().getDefaultSuffix();
        this.defaultReplyTo = Mailer.descriptor().getReplyToAddress();
        this.useSsl = Mailer.descriptor().getUseSsl();
        if (StringUtils.isNotBlank((String)Mailer.descriptor().getSmtpAuthUserName())) {
            this.smtpAuthPassword = Secret.fromString((String)Mailer.descriptor().getSmtpAuthPassword());
            this.smtpAuthUsername = Mailer.descriptor().getSmtpAuthUserName();
        }
        this.smtpPort = Mailer.descriptor().getSmtpPort();
        this.smtpHost = Mailer.descriptor().getSmtpServer();
        this.charset = Mailer.descriptor().getCharset();
        this.overrideGlobalSettings = true;
    }

    public String getHelpFile() {
        return "/plugin/email-ext/help/main.html";
    }

    public FormValidation doAddressCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            new InternetAddress(value);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public FormValidation doRecipientListRecipientsCheck(@QueryParameter String value) throws IOException, ServletException {
        return new EmailRecipientUtils().validateFormRecipientList(value);
    }

    public FormValidation doMaxAttachmentSizeCheck(@QueryParameter String value) throws IOException, ServletException {
        try {
            String testValue = value.trim();
            if (testValue.length() > 0) {
                Long.parseLong(testValue);
            }
            return FormValidation.ok();
        }
        catch (Exception e) {
            return FormValidation.error((String)e.getMessage());
        }
    }

    public boolean isMatrixProject(Object project) {
        return project instanceof MatrixProject;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public void debug(PrintStream logger, String format, Object ... args) {
        if (this.debugMode) {
            logger.format(format, args);
            logger.println();
        }
    }
}

