/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.watching;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.JobProperty;
import hudson.model.User;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.watching.EmailExtWatchJobProperty;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class EmailExtWatchAction
implements Action {
    private AbstractProject<?, ?> project;

    public EmailExtWatchAction(AbstractProject project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        if (this.isWatching()) {
            return Messages.EmailExtWatchAction_DisplayNameWatching();
        }
        return Messages.EmailExtWatchAction_DisplayName();
    }

    public String getUrlName() {
        return "emailExtWatch";
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public boolean isWatching() {
        List<EmailTrigger> triggers = this.getTriggers();
        return triggers != null && !triggers.isEmpty();
    }

    public List<EmailTrigger> getTriggers() {
        UserProperty p;
        List<EmailTrigger> triggers = null;
        User current = User.current();
        if (current != null && (p = (UserProperty)current.getProperty(UserProperty.class)) != null) {
            triggers = p.getTriggers();
        }
        return triggers;
    }

    public EmailExtWatchJobProperty getJobProperty() throws IOException {
        EmailExtWatchJobProperty prop = (EmailExtWatchJobProperty)this.project.getProperty(EmailExtWatchJobProperty.class);
        if (prop == null) {
            prop = new EmailExtWatchJobProperty();
            this.project.addProperty((JobProperty)prop);
        }
        return prop;
    }

    public Mailer.UserProperty getMailerProperty() {
        Mailer.UserProperty prop = null;
        User current = User.current();
        if (current != null) {
            prop = (Mailer.UserProperty)current.getProperty(Mailer.UserProperty.class);
        }
        return prop;
    }

    public ExtendedEmailPublisher getPublisher() {
        ExtendedEmailPublisher p = null;
        for (Publisher pub : this.project.getPublishersList()) {
            if (!(pub instanceof ExtendedEmailPublisher)) continue;
            p = (ExtendedEmailPublisher)pub;
        }
        return p;
    }

    public void doStopWatching(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        User user = User.current();
        if (user != null) {
            this.stopWatching();
            for (hudson.model.UserProperty property : user.getAllProperties()) {
                if (!(property instanceof UserProperty)) continue;
                ((UserProperty)property).clearTriggers();
                break;
            }
        }
        rsp.sendRedirect(this.project.getAbsoluteUrl());
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        User user = User.current();
        if (user != null) {
            Object json = req.getSubmittedForm().get("triggers");
            List triggers = req.bindJSONToList(EmailTrigger.class, json);
            ArrayList<EmailTrigger> unwatchable = new ArrayList<EmailTrigger>();
            for (EmailTrigger trigger : triggers) {
                if (trigger.getDescriptor().isWatchable()) continue;
                unwatchable.add(trigger);
            }
            triggers.removeAll(unwatchable);
            Mailer.UserProperty mailerProperty = this.getMailerProperty();
            if (mailerProperty != null) {
                for (EmailTrigger trigger : triggers) {
                    trigger.getEmail().setRecipientList(mailerProperty.getAddress());
                    trigger.getEmail().getRecipientProviders().clear();
                }
                this.startWatching();
                user.addProperty((hudson.model.UserProperty)new UserProperty(triggers));
            }
        }
        rsp.sendRedirect(this.project.getAbsoluteUrl());
    }

    public void startWatching() throws IOException {
        User user = User.current();
        if (user != null) {
            this.getJobProperty().addWatcher(user);
            this.project.save();
        }
    }

    public void stopWatching() throws IOException {
        User user = User.current();
        if (user != null) {
            this.getJobProperty().removeWatcher(user);
            this.project.save();
        }
    }

    public boolean isWatching(User user) throws IOException {
        return this.getJobProperty().isWatching(user);
    }

    public static class UserProperty
    extends hudson.model.UserProperty {
        private List<EmailTrigger> triggers = new ArrayList<EmailTrigger>();

        public UserProperty(List<EmailTrigger> triggers) {
            if (triggers != null) {
                this.triggers = Collections.unmodifiableList(triggers);
            }
        }

        @Exported
        public List<EmailTrigger> getTriggers() {
            return this.triggers;
        }

        private void clearTriggers() {
            this.triggers = Collections.emptyList();
        }

        @Extension
        public static final class DescriptorImpl
        extends UserPropertyDescriptor {
            public DescriptorImpl() {
                super(UserProperty.class);
            }

            public String getDisplayName() {
                return "Extended Email Job Watching";
            }

            public UserProperty newInstance(User user) {
                return new UserProperty(null);
            }

            public UserProperty newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
                List triggers = req.bindJSONToList(EmailTrigger.class, (Object)json);
                return new UserProperty(triggers);
            }
        }
    }
}

