/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.ExtensionList;
import hudson.Plugin;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.GroovyTemplateConfig;
import hudson.plugins.emailext.JellyTemplateConfig;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.content.JellyScriptContent;
import hudson.plugins.emailext.plugins.content.ScriptContent;
import hudson.util.FormValidation;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class EmailExtTemplateAction
implements Action {
    private final AbstractProject<?, ?> project;

    public EmailExtTemplateAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.EmailExtTemplateAction_DisplayName();
    }

    public String getUrlName() {
        return "templateTest";
    }

    private String renderError(Exception ex) {
        StringBuilder builder = new StringBuilder();
        builder.append("<h3>An error occured trying to render the template:</h3><br/><span style=\"color:red; font-weight:bold\">").append(ex.toString().replace("\n", "<br/>")).append("</span>");
        return builder.toString();
    }

    public FormValidation doTemplateFileCheck(@QueryParameter String value) {
        if (!StringUtils.isEmpty((String)value)) {
            File scriptsFolder;
            File scriptFile;
            if (value.startsWith("managed:")) {
                return this.checkForManagedFile(value);
            }
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + value);
            if (inputStream == null && !(scriptFile = new File(scriptsFolder = new File(Jenkins.getActiveInstance().getRootDir(), "email-templates"), value)).exists()) {
                return FormValidation.error((String)("The file '" + value + "' does not exist"));
            }
        }
        return FormValidation.ok();
    }

    private FormValidation checkForManagedFile(String value) {
        Plugin plugin = Jenkins.getActiveInstance().getPlugin("config-file-provider");
        if (plugin != null) {
            Object config = null;
            Collection<ConfigProvider> providers = EmailExtTemplateAction.getTemplateConfigProviders();
            for (ConfigProvider provider : providers) {
                for (Config c : provider.getAllConfigs()) {
                    if (!c.name.equalsIgnoreCase(value)) continue;
                    return FormValidation.ok();
                }
            }
        } else {
            return FormValidation.error((String)Messages.EmailExtTemplateAction_ConfigFileProviderNotAvailable());
        }
        return FormValidation.error((String)Messages.EmailExtTemplateAction_ManagedTemplateNotFound());
    }

    private static Collection<ConfigProvider> getTemplateConfigProviders() {
        ArrayList<ConfigProvider> providers = new ArrayList<ConfigProvider>();
        ExtensionList all = ConfigProvider.all();
        ConfigProvider p = (ConfigProvider)all.get(GroovyTemplateConfig.GroovyTemplateConfigProvider.class);
        if (p != null) {
            providers.add(p);
        }
        if ((p = (ConfigProvider)all.get(JellyTemplateConfig.JellyTemplateConfigProvider.class)) != null) {
            providers.add(p);
        }
        return providers;
    }

    @JavaScriptMethod
    public String[] renderTemplate(String templateFile, String buildId) {
        String[] result = new String[]{"", ""};
        try {
            AbstractBuild build = this.project.getBuild(buildId);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamTaskListener listener = new StreamTaskListener((OutputStream)stream);
            if (templateFile.endsWith(".jelly")) {
                JellyScriptContent jellyContent = new JellyScriptContent();
                jellyContent.template = templateFile;
                result[0] = jellyContent.evaluate(build, (TaskListener)listener, "JELLY_SCRIPT");
            } else {
                ScriptContent scriptContent = new ScriptContent();
                scriptContent.template = templateFile;
                result[0] = scriptContent.evaluate(build, (TaskListener)listener, "SCRIPT");
            }
            result[1] = stream.toString(ExtendedEmailPublisher.descriptor().getCharset());
        }
        catch (Exception ex) {
            result[0] = this.renderError(ex);
        }
        return result;
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }
}

