/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.recipients.DevelopersRecipientProvider;
import hudson.plugins.emailext.plugins.recipients.ListRecipientProvider;
import java.util.List;

public abstract class NthFailureTrigger
extends EmailTrigger {
    protected int failureCount;

    public NthFailureTrigger(int failureCount, List<RecipientProvider> recipientProviders, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(recipientProviders, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.failureCount = failureCount;
    }

    @Deprecated
    public NthFailureTrigger(int failureCount, boolean sendToList, boolean sendToDevs, boolean sendToRequester, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(sendToList, sendToDevs, sendToRequester, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.failureCount = failureCount;
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        AbstractBuild<?, ?> run = build;
        for (int i = 0; i < this.failureCount; ++i) {
            if (run == null) {
                return false;
            }
            Result buildResult = run.getResult();
            if (buildResult != Result.FAILURE) {
                return false;
            }
            run = ExtendedEmailPublisher.getPreviousRun(run, listener);
        }
        return run == null || run.getResult() == Result.SUCCESS || run.getResult() == Result.UNSTABLE;
    }

    public static abstract class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Failure - Any");
            this.addTriggerNameToReplace("Failure - Still");
            this.addDefaultRecipientProvider(new DevelopersRecipientProvider());
            this.addDefaultRecipientProvider(new ListRecipientProvider());
        }
    }
}

