/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.GroovyTemplateConfig;
import hudson.plugins.emailext.plugins.content.AbstractEvalContent;
import hudson.plugins.emailext.plugins.content.EmailExtScript;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class ScriptContent
extends AbstractEvalContent {
    private static final Logger LOGGER = Logger.getLogger(ScriptContent.class.getName());
    @DataBoundTokenMacro.Parameter
    public String script = "";
    private static final String DEFAULT_TEMPLATE_NAME = "groovy-html.template";
    @DataBoundTokenMacro.Parameter
    public String template = "groovy-html.template";
    public static final String MACRO_NAME = "SCRIPT";
    private static final Map<String, Reference<Template>> templateCache = new HashMap<String, Reference<Template>>();

    public ScriptContent() {
        super(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String result;
        InputStream inputStream;
        block7: {
            inputStream = null;
            result = "";
            try {
                if (!StringUtils.isEmpty((String)this.script)) {
                    inputStream = this.getFileInputStream(context.getWorkspace(), this.script, ".groovy");
                    result = this.executeScript(context, listener, inputStream);
                    break block7;
                }
                inputStream = this.getFileInputStream(context.getWorkspace(), this.template, ".template");
                result = this.renderTemplate(context, listener, inputStream);
            }
            catch (FileNotFoundException e) {
                String missingScriptError = "";
                missingScriptError = !StringUtils.isEmpty((String)this.script) ? this.generateMissingFile("Groovy Script", this.script) : this.generateMissingFile("Groovy Template", this.template);
                LOGGER.log(Level.SEVERE, missingScriptError);
                result = missingScriptError;
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (GroovyRuntimeException e2) {
                result = "Error in script or template: " + e2.toString();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    @Override
    protected Class<? extends ConfigProvider> getProviderClass() {
        return GroovyTemplateConfig.GroovyTemplateConfigProvider.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderTemplate(AbstractBuild<?, ?> build, TaskListener listener, InputStream templateStream) throws IOException {
        String result;
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getActiveInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        binding.put("build", build);
        binding.put("listener", listener);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("rooturl", descriptor.getHudsonUrl());
        binding.put("project", build.getParent());
        GroovyShell shell = this.createEngine(descriptor, Collections.emptyMap());
        SimpleTemplateEngine engine = new SimpleTemplateEngine(shell);
        try {
            Template tmpl;
            String text = IOUtils.toString((InputStream)templateStream);
            Map<String, Reference<Template>> map = templateCache;
            synchronized (map) {
                Reference<Template> templateR = templateCache.get(text);
                Template template = tmpl = templateR == null ? null : templateR.get();
                if (tmpl == null) {
                    tmpl = engine.createTemplate(text);
                    templateCache.put(text, new SoftReference<Template>(tmpl));
                }
            }
            result = tmpl.make(binding).toString();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            result = "Exception raised during template rendering: " + e.getMessage() + "\n\n" + sw.toString();
        }
        return result;
    }

    private String executeScript(AbstractBuild<?, ?> build, TaskListener listener, InputStream scriptStream) throws IOException {
        String result = "";
        HashMap<String, Object> binding = new HashMap<String, Object>();
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.getActiveInstance().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        binding.put("build", build);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("project", build.getParent());
        binding.put("rooturl", descriptor.getHudsonUrl());
        binding.put("logger", listener.getLogger());
        GroovyShell shell = this.createEngine(descriptor, binding);
        Object res = shell.evaluate((Reader)new InputStreamReader(scriptStream, descriptor.getCharset()));
        if (res != null) {
            result = res.toString();
        }
        return result;
    }

    private GroovyShell createEngine(ExtendedEmailPublisherDescriptor descriptor, Map<String, Object> variables) throws IOException {
        ClassLoader cl = Jenkins.getActiveInstance().getPluginManager().uberClassLoader;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(EmailExtScript.class.getCanonicalName());
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        Binding binding = new Binding();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            binding.setVariable(e.getKey(), e.getValue());
        }
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        return shell;
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

