/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.trigger.AlwaysTrigger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class EmailExtStep
extends AbstractStepImpl {
    public final String subject;
    public final String body;
    @CheckForNull
    private String attachmentsPattern;
    @CheckForNull
    private String to;
    @CheckForNull
    private String replyTo;
    @CheckForNull
    private String mimeType;
    private boolean attachLog;
    private boolean compressLog;

    @DataBoundConstructor
    public EmailExtStep(String subject, String body) {
        this.subject = subject;
        this.body = body;
    }

    @CheckForNull
    public String getAttachmentsPattern() {
        return this.attachmentsPattern == null ? "" : this.attachmentsPattern;
    }

    @DataBoundSetter
    public void setAttachmentsPattern(@CheckForNull String attachmentsPattern) {
        if (StringUtils.isNotBlank((String)attachmentsPattern)) {
            this.attachmentsPattern = attachmentsPattern;
        }
    }

    @CheckForNull
    public String getTo() {
        return this.to == null ? "" : this.to;
    }

    @DataBoundSetter
    public void setTo(@CheckForNull String to) {
        this.to = Util.fixNull((String)to);
    }

    @CheckForNull
    public String getReplyTo() {
        return this.replyTo == null ? "" : this.replyTo;
    }

    @DataBoundSetter
    public void setReplyTo(@CheckForNull String replyTo) {
        this.replyTo = Util.fixNull((String)replyTo);
    }

    @CheckForNull
    public String getMimeType() {
        return this.mimeType == null ? "" : this.mimeType;
    }

    @DataBoundSetter
    public void setMimeType(@CheckForNull String mimeType) {
        this.mimeType = Util.fixNull((String)mimeType);
    }

    public boolean getAttachLog() {
        return this.attachLog;
    }

    @DataBoundSetter
    public void setAttachLog(boolean attachLog) {
        this.attachLog = attachLog;
    }

    public boolean getCompressLog() {
        return this.compressLog;
    }

    @DataBoundSetter
    public void setCompressLog(boolean compressLog) {
        this.compressLog = compressLog;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public static final String defaultMimeType = "text/plain";

        public DescriptorImpl() {
            super(EmailExtStepExecution.class);
        }

        public String getFunctionName() {
            return "emailext";
        }

        public String getDisplayName() {
            return "Extended Email";
        }
    }

    public static class EmailExtStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient EmailExtStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient Run<?, ?> run;
        @StepContextParameter
        private transient FilePath workspace;

        protected Void run() throws Exception {
            ExtendedEmailPublisher publisher = new ExtendedEmailPublisher();
            publisher.configuredTriggers.clear();
            AlwaysTrigger.DescriptorImpl descriptor = (AlwaysTrigger.DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(AlwaysTrigger.DescriptorImpl.class);
            publisher.configuredTriggers.add(descriptor.createDefault());
            publisher.defaultSubject = this.step.subject;
            publisher.defaultContent = this.step.body;
            publisher.attachBuildLog = this.step.attachLog;
            publisher.compressBuildLog = this.step.compressLog;
            if (StringUtils.isNotBlank((String)this.step.to)) {
                publisher.recipientList = this.step.to;
            }
            if (StringUtils.isNotBlank((String)this.step.replyTo)) {
                publisher.replyTo = this.step.replyTo;
            }
            if (StringUtils.isNotBlank((String)this.step.attachmentsPattern)) {
                publisher.attachmentsPattern = this.step.attachmentsPattern;
            }
            if (StringUtils.isNotBlank((String)this.step.mimeType)) {
                publisher.contentType = this.step.mimeType;
            }
            ExtendedEmailPublisherContext ctx = new ExtendedEmailPublisherContext(publisher, this.run, this.workspace, this.launcher, this.listener);
            ArrayListMultimap triggered = ArrayListMultimap.create();
            triggered.put((Object)"Always", (Object)publisher.configuredTriggers.get(0));
            ctx.setTrigger(publisher.configuredTriggers.get(0));
            ctx.setTriggered((Multimap<String, EmailTrigger>)triggered);
            publisher.sendMail(ctx);
            return null;
        }
    }
}

