/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.Util;
import hudson.scm.ChangeLogSet;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class ChangesSinceLastBuildContent
extends DataBoundTokenMacro {
    public static final String FORMAT_DEFAULT_VALUE = "[%a] %m\\n";
    public static final String PATH_FORMAT_DEFAULT_VALUE = "\\t%p\\n";
    public static final String FORMAT_DEFAULT_VALUE_WITH_PATHS = "[%a] %m%p\\n";
    public static final String DEFAULT_DEFAULT_VALUE = "No changes\n";
    public static final String MACRO_NAME = "CHANGES";
    @DataBoundTokenMacro.Parameter
    public boolean showPaths = false;
    @DataBoundTokenMacro.Parameter
    public String format;
    @DataBoundTokenMacro.Parameter
    public String pathFormat = "\\t%p\\n";
    @DataBoundTokenMacro.Parameter
    public boolean showDependencies = false;
    @DataBoundTokenMacro.Parameter
    public String dateFormat;
    @DataBoundTokenMacro.Parameter
    public String regex;
    @DataBoundTokenMacro.Parameter
    public String replace;
    @DataBoundTokenMacro.Parameter(alias="default")
    public String def = "No changes\n";

    public ChangesSinceLastBuildContent() {
    }

    public ChangesSinceLastBuildContent(String format, String pathFormat, boolean showPaths) {
        this.format = format;
        this.pathFormat = pathFormat;
        this.showPaths = showPaths;
    }

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        AbstractBuild<?, ?> previousBuild;
        if (StringUtils.isEmpty((String)this.format)) {
            this.format = this.showPaths ? FORMAT_DEFAULT_VALUE_WITH_PATHS : FORMAT_DEFAULT_VALUE;
        }
        DateFormat dateFormatter = StringUtils.isEmpty((String)this.dateFormat) ? DateFormat.getDateTimeInstance(2, 2) : new SimpleDateFormat(this.dateFormat);
        StringBuffer buf = new StringBuffer();
        if (!build.getChangeSet().isEmptySet()) {
            for (ChangeLogSet.Entry entry : build.getChangeSet()) {
                Util.printf(buf, this.format, new ChangesSincePrintfSpec(entry, this.pathFormat, dateFormatter));
            }
        } else {
            buf.append(this.def);
        }
        if (this.showDependencies && (previousBuild = ExtendedEmailPublisher.getPreviousBuild(build, listener)) != null) {
            for (Map.Entry e : build.getDependencyChanges(previousBuild).entrySet()) {
                buf.append("\n=======================\n");
                buf.append("\nChanges in ").append(((AbstractProject)e.getKey()).getName()).append(":\n");
                for (AbstractBuild b : ((AbstractBuild.DependencyChange)e.getValue()).getBuilds()) {
                    if (!b.getChangeSet().isEmptySet()) {
                        for (ChangeLogSet.Entry entry : b.getChangeSet()) {
                            Util.printf(buf, this.format, new ChangesSincePrintfSpec(entry, this.pathFormat, dateFormatter));
                        }
                        continue;
                    }
                    buf.append(this.def);
                }
            }
        }
        return buf.toString();
    }

    public boolean hasNestedContent() {
        return true;
    }

    public class ChangesSincePrintfSpec
    implements Util.PrintfSpec {
        private final ChangeLogSet.Entry entry;
        private final String pathFormatString;
        private final DateFormat dateFormatter;

        public ChangesSincePrintfSpec(ChangeLogSet.Entry entry, String pathFormatString, DateFormat dateFormatter) {
            this.entry = entry;
            this.pathFormatString = pathFormatString;
            this.dateFormatter = dateFormatter;
        }

        @Override
        public boolean printSpec(StringBuffer buf, char formatChar) {
            switch (formatChar) {
                case 'a': {
                    buf.append(this.entry.getAuthor().getFullName());
                    return true;
                }
                case 'd': {
                    try {
                        buf.append(this.dateFormatter.format(new Date(this.entry.getTimestamp())));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return true;
                }
                case 'm': {
                    String m = this.entry.getMsg();
                    if (!StringUtils.isEmpty((String)ChangesSinceLastBuildContent.this.regex) && !StringUtils.isEmpty((String)ChangesSinceLastBuildContent.this.replace)) {
                        m = m.replaceAll(ChangesSinceLastBuildContent.this.regex, ChangesSinceLastBuildContent.this.replace);
                    }
                    buf.append(m);
                    if (m == null || !m.endsWith("\n")) {
                        buf.append('\n');
                    }
                    return true;
                }
                case 'p': {
                    try {
                        Collection affectedFiles = this.entry.getAffectedFiles();
                        for (final ChangeLogSet.AffectedFile file : affectedFiles) {
                            Util.printf(buf, this.pathFormatString, new Util.PrintfSpec(){

                                @Override
                                public boolean printSpec(StringBuffer buf, char formatChar) {
                                    if (formatChar == 'p') {
                                        buf.append(file.getPath());
                                        return true;
                                    }
                                    if (formatChar == 'a') {
                                        buf.append(file.getEditType().getName());
                                        return true;
                                    }
                                    if (formatChar == 'd') {
                                        buf.append(file.getEditType().getDescription());
                                        return true;
                                    }
                                    return false;
                                }
                            });
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        Collection affectedPaths = this.entry.getAffectedPaths();
                        for (final String affectedPath : affectedPaths) {
                            Util.printf(buf, this.pathFormatString, new Util.PrintfSpec(){

                                @Override
                                public boolean printSpec(StringBuffer buf, char formatChar) {
                                    if (formatChar == 'p') {
                                        buf.append(affectedPath);
                                        return true;
                                    }
                                    if (formatChar == 'a') {
                                        buf.append("Unknown");
                                        return true;
                                    }
                                    if (formatChar == 'd') {
                                        buf.append("Unknown");
                                        return true;
                                    }
                                    return false;
                                }
                            });
                        }
                    }
                    return true;
                }
                case 'r': {
                    try {
                        buf.append(this.entry.getCommitId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
            }
            return false;
        }
    }
}

