/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.plugins.emailext.EmailRecipientUtils;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.tasks.Mailer;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.logging.Logger;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class RequesterRecipientProvider
extends RecipientProvider {
    private static final Logger LOGGER = Logger.getLogger(RequesterRecipientProvider.class.getName());

    @DataBoundConstructor
    public RequesterRecipientProvider() {
    }

    @Override
    public void addRecipients(ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        AbstractProject p;
        AbstractBuild cur = context.getBuild();
        Cause.UpstreamCause upc = (Cause.UpstreamCause)context.getBuild().getCause(Cause.UpstreamCause.class);
        while (upc != null && (p = (AbstractProject)Jenkins.getInstance().getItemByFullName(upc.getUpstreamProject())) != null) {
            cur = p.getBuildByNumber(upc.getUpstreamBuild());
            upc = (Cause.UpstreamCause)cur.getCause(Cause.UpstreamCause.class);
        }
        RequesterRecipientProvider.addUserTriggeringTheBuild(cur, to, cc, bcc, env, (TaskListener)context.getListener());
    }

    public static User getUserTriggeringTheBuild(AbstractBuild<?, ?> build) {
        User user = RequesterRecipientProvider.getByUserIdCause(build);
        if (user == null) {
            user = RequesterRecipientProvider.getByLegacyUserCause(build);
        }
        return user;
    }

    private static void addUserTriggeringTheBuild(AbstractBuild<?, ?> build, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, TaskListener listener) {
        User user = RequesterRecipientProvider.getUserTriggeringTheBuild(build);
        if (user != null) {
            String adrs = ((Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class)).getAddress();
            if (adrs != null) {
                EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, adrs, env, listener);
            } else {
                listener.getLogger().println("The user does not have a configured email address, trying the user's id");
                EmailRecipientUtils.addAddressesFromRecipientList(to, cc, bcc, user.getId(), env, listener);
            }
        }
    }

    private static User getByUserIdCause(AbstractBuild<?, ?> build) {
        try {
            Cause.UserIdCause cause = (Cause.UserIdCause)build.getCause(Cause.UserIdCause.class);
            if (cause != null) {
                String id = cause.getUserId();
                return User.get((String)id, (boolean)false, null);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    private static User getByLegacyUserCause(AbstractBuild<?, ?> build) {
        try {
            Cause.UserCause userCause = (Cause.UserCause)build.getCause(Cause.UserCause.class);
            if (userCause != null) {
                Field authenticationName = Cause.UserCause.class.getDeclaredField("authenticationName");
                authenticationName.setAccessible(true);
                String name = (String)authenticationName.get(userCause);
                return User.get((String)name, (boolean)false, null);
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        public String getDisplayName() {
            return "Requestor";
        }
    }
}

