/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailedTestsContent
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public boolean showStack = true;
    @DataBoundTokenMacro.Parameter
    public boolean showMessage = true;
    @DataBoundTokenMacro.Parameter
    public int maxTests = Integer.MAX_VALUE;
    @DataBoundTokenMacro.Parameter
    public boolean onlyRegressions = false;
    @DataBoundTokenMacro.Parameter
    public int maxLength = Integer.MAX_VALUE;
    public static final String MACRO_NAME = "FAILED_TESTS";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        StringBuilder buffer = new StringBuilder();
        AbstractTestResultAction testResult = build.getTestResultAction();
        if (null == testResult) {
            return "No tests ran.";
        }
        int failCount = testResult.getFailCount();
        if (failCount == 0) {
            buffer.append("All tests passed");
        } else {
            boolean showOldFailures;
            buffer.append(failCount);
            buffer.append(" tests failed.");
            buffer.append('\n');
            boolean bl = showOldFailures = !this.onlyRegressions;
            if (this.maxLength < Integer.MAX_VALUE) {
                this.maxLength *= 1024;
            }
            if (this.maxTests > 0) {
                int printedTests = 0;
                int printedLength = 0;
                for (CaseResult failedTest : testResult.getFailedTests()) {
                    if (!showOldFailures && failedTest.getAge() != 1 || printedTests >= this.maxTests || printedLength > this.maxLength) continue;
                    printedLength += this.outputTest(buffer, failedTest, this.showStack, this.showMessage, this.maxLength - printedLength);
                    ++printedTests;
                }
                if (failCount > printedTests) {
                    buffer.append("... and ");
                    buffer.append(failCount - printedTests);
                    buffer.append(" other failed tests.\n\n");
                }
                if (printedLength >= this.maxLength) {
                    buffer.append("\n\n... output truncated.\n\n");
                }
            }
        }
        return buffer.toString();
    }

    private int outputTest(StringBuilder buffer, CaseResult failedTest, boolean showStack, boolean showMessage, int lengthLeft) {
        StringBuilder local = new StringBuilder();
        int currLength = buffer.length();
        local.append(failedTest.getStatus().toString());
        local.append(":  ");
        local.append(failedTest.getClassName());
        local.append(".");
        local.append(failedTest.getDisplayName());
        local.append("\n");
        if (showMessage) {
            local.append("\n");
            local.append("Error Message:\n");
            local.append(failedTest.getErrorDetails());
            local.append("\n");
        }
        if (showStack) {
            local.append("\n");
            local.append("Stack Trace:\n");
            local.append(failedTest.getErrorStackTrace());
            local.append("\n");
        }
        if (showMessage || showStack) {
            local.append("\n");
        }
        if (local.length() > lengthLeft) {
            local.setLength(lengthLeft);
        }
        buffer.append(local.toString());
        return local.length();
    }
}

