/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.recipients.DevelopersRecipientProvider;
import hudson.plugins.emailext.plugins.recipients.ListRecipientProvider;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedUnhealthyTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Unstable (Test Failures)/Failure -> Success";

    @DataBoundConstructor
    public FixedUnhealthyTrigger(List<RecipientProvider> recipientProviders, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(recipientProviders, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Deprecated
    public FixedUnhealthyTrigger(boolean sendToList, boolean sendToDevs, boolean sendToRequester, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(sendToList, sendToDevs, sendToRequester, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        AbstractBuild<?, ?> prevBuild;
        Result buildResult = build.getResult();
        return buildResult == Result.SUCCESS && (prevBuild = this.getPreviousBuild(build, listener)) != null && (prevBuild.getResult() == Result.UNSTABLE || prevBuild.getResult() == Result.FAILURE);
    }

    private AbstractBuild<?, ?> getPreviousBuild(AbstractBuild<?, ?> build, TaskListener listener) {
        AbstractBuild<?, ?> prevBuild = ExtendedEmailPublisher.getPreviousBuild(build, listener);
        if (prevBuild != null && prevBuild.getResult() == Result.ABORTED) {
            return this.getPreviousBuild(prevBuild, listener);
        }
        return prevBuild;
    }

    @Extension
    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Success");
            this.addDefaultRecipientProvider(new DevelopersRecipientProvider());
            this.addDefaultRecipientProvider(new ListRecipientProvider());
        }

        public String getDisplayName() {
            return FixedUnhealthyTrigger.TRIGGER_NAME;
        }
    }
}

