/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NthFailureTrigger
extends EmailTrigger {
    protected int failureCount;

    public NthFailureTrigger(int failureCount, boolean sendToList, boolean sendToDevs, boolean sendToRequestor, boolean sendToCulprits, String recipientList, String replyTo, String subject, String body, String attachmentsPattern, int attachBuildLog, String contentType) {
        super(sendToList, sendToDevs, sendToRequestor, sendToCulprits, recipientList, replyTo, subject, body, attachmentsPattern, attachBuildLog, contentType);
        this.failureCount = failureCount;
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build, TaskListener listener) {
        for (int i = 0; i < this.failureCount; ++i) {
            if (build == null) {
                return false;
            }
            Result buildResult = build.getResult();
            if (buildResult != Result.FAILURE) {
                return false;
            }
            build = ExtendedEmailPublisher.getPreviousBuild(build, listener);
        }
        return build == null || build.getResult() == Result.SUCCESS;
    }

    public static abstract class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Failure");
            this.addTriggerNameToReplace("Still Failing");
        }

        public boolean getDefaultSendToDevs() {
            return true;
        }

        public boolean getDefaultSendToList() {
            return true;
        }
    }
}

