/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.TaskListener;
import hudson.plugins.emailext.Util;
import hudson.plugins.emailext.plugins.content.ChangesSinceLastBuildContent;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChangesSinceContent
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public boolean reverse = false;
    @DataBoundTokenMacro.Parameter
    public String format;
    @DataBoundTokenMacro.Parameter
    public boolean showPaths = false;
    @DataBoundTokenMacro.Parameter
    public String changesFormat;
    @DataBoundTokenMacro.Parameter
    public String pathFormat = "\\t%p\\n";

    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        AbstractBuild<?, ?> endBuild;
        AbstractBuild startBuild;
        if (build.getPreviousBuild() == null) {
            return "";
        }
        if (StringUtils.isEmpty((String)this.format)) {
            this.format = this.getDefaultFormatValue();
        }
        StringBuffer sb = new StringBuffer();
        if (this.reverse) {
            startBuild = build;
            endBuild = this.getFirstIncludedBuild(build);
        } else {
            startBuild = this.getFirstIncludedBuild(build);
            endBuild = build;
        }
        AbstractBuild currentBuild = null;
        while (currentBuild != endBuild) {
            currentBuild = currentBuild == null ? startBuild : (this.reverse ? currentBuild.getPreviousBuild() : currentBuild.getNextBuild());
            this.appendBuild(sb, listener, currentBuild);
        }
        return sb.toString();
    }

    private <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> void appendBuild(StringBuffer buf, final TaskListener listener, final AbstractBuild<P, B> currentBuild) throws MacroEvaluationException {
        final ChangesSinceLastBuildContent changes = new ChangesSinceLastBuildContent(this.changesFormat, this.pathFormat, this.showPaths);
        Util.printf(buf, this.format, new Util.PrintfSpec(){

            public boolean printSpec(StringBuffer buf, char formatChar) {
                switch (formatChar) {
                    case 'c': {
                        try {
                            buf.append(changes.evaluate(currentBuild, listener, "CHANGES"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return true;
                    }
                    case 'n': {
                        buf.append(currentBuild.getNumber());
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public boolean hasNestedContent() {
        return true;
    }

    public abstract String getDefaultFormatValue();

    public abstract String getShortHelpDescription();

    public abstract <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> AbstractBuild<P, B> getFirstIncludedBuild(AbstractBuild<P, B> var1);
}

