/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NthFailureTrigger
extends EmailTrigger {
    protected int failureCount;

    public NthFailureTrigger(int failureCount) {
        this.failureCount = failureCount;
    }

    @Override
    public boolean trigger(AbstractBuild<?, ?> build) {
        for (int i = 0; i < this.failureCount; ++i) {
            if (build == null) {
                return false;
            }
            Result buildResult = build.getResult();
            if (buildResult != Result.FAILURE) {
                return false;
            }
            build = build.getPreviousBuild();
        }
        return build == null || build.getResult() == Result.SUCCESS;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return true;
    }

    public static abstract class DescriptorImpl
    extends EmailTriggerDescriptor {
        public DescriptorImpl() {
            this.addTriggerNameToReplace("Failure");
            this.addTriggerNameToReplace("Still Failing");
        }
    }
}

