/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import hudson.model.AbstractBuild;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import hudson.plugins.emailext.plugins.trigger.Messages;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovementTrigger
extends EmailTrigger {
    public static final String TRIGGER_NAME = "Improvement";
    public static DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Override
    public boolean trigger(AbstractBuild<?, ?> build) {
        if (build.getPreviousBuild() == null) {
            return false;
        }
        if (build.getTestResultAction() == null) {
            return false;
        }
        if (build.getPreviousBuild().getTestResultAction() == null) {
            return false;
        }
        int numCurrFailures = this.getNumFailures(build);
        return build.getTestResultAction().getTotalCount() > 0 && numCurrFailures < this.getNumFailures(build.getPreviousBuild()) && numCurrFailures > 0;
    }

    @Override
    public EmailTriggerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public boolean getDefaultSendToDevs() {
        return true;
    }

    @Override
    public boolean getDefaultSendToList() {
        return true;
    }

    public static final class DescriptorImpl
    extends EmailTriggerDescriptor {
        public String getTriggerName() {
            return ImprovementTrigger.TRIGGER_NAME;
        }

        public EmailTrigger newInstance(StaplerRequest req, JSONObject formData) {
            return new ImprovementTrigger();
        }

        public String getHelpText() {
            return Messages.ImprovementTrigger_HelpText();
        }
    }
}

