/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.trigger;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.model.AbstractBuild;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.plugins.EmailTriggerDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScriptTrigger
extends EmailTrigger {
    protected String triggerScript;

    public String getTriggerScript() {
        return this.triggerScript;
    }

    @Override
    public abstract boolean isPreBuild();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trigger(AbstractBuild<?, ?> build) {
        boolean result = false;
        GroovyShell engine = this.createEngine(build);
        if (engine != null && !StringUtils.isEmpty((String)this.triggerScript)) {
            Object res = engine.evaluate(this.triggerScript);
            if (res != null) {
                result = (Boolean)res;
            }
        }
        return result;
    }

    private GroovyShell createEngine(AbstractBuild<?, ?> build) {
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        ScriptSandbox sandbox = null;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        if (ExtendedEmailPublisher.DESCRIPTOR.isSecurityEnabled()) {
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
            sandbox = new ScriptSandbox();
        }
        Binding binding = new Binding();
        binding.setVariable("build", build);
        binding.setVariable("project", (Object)build.getParent());
        binding.setVariable("rooturl", (Object)ExtendedEmailPublisher.DESCRIPTOR.getHudsonUrl());
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        if (sandbox != null) {
            sandbox.register();
        }
        return shell;
    }

    @Override
    public abstract EmailTriggerDescriptor getDescriptor();

    @Override
    public boolean getDefaultSendToDevs() {
        return false;
    }

    @Override
    public boolean getDefaultSendToList() {
        return true;
    }

    public static abstract class DescriptorImpl
    extends EmailTriggerDescriptor {
    }
}

