/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.text.SimpleTemplateEngine;
import hudson.model.AbstractBuild;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ScriptSandbox;
import hudson.plugins.emailext.plugins.ContentBuilder;
import hudson.plugins.emailext.plugins.content.ScriptContentBuildWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptContent
extends DataBoundTokenMacro {
    private static final Logger LOGGER = Logger.getLogger(ScriptContent.class.getName());
    @DataBoundTokenMacro.Parameter
    public String script = "";
    private static final String DEFAULT_TEMPLATE_NAME = "groovy-html.template";
    @DataBoundTokenMacro.Parameter
    public String template = "groovy-html.template";
    private static final String EMAIL_TEMPLATES_DIRECTORY = "email-templates";
    public static final String MACRO_NAME = "SCRIPT";

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String result;
        InputStream inputStream;
        block7: {
            inputStream = null;
            result = "";
            try {
                if (!StringUtils.isEmpty((String)this.script)) {
                    inputStream = this.getFileInputStream(this.script);
                    result = this.executeScript(context, listener, inputStream);
                    break block7;
                }
                inputStream = this.getFileInputStream(this.template);
                result = this.renderTemplate(context, listener, inputStream);
            }
            catch (FileNotFoundException e) {
                String missingScriptError = this.generateMissingFile(this.script, this.template);
                LOGGER.log(Level.SEVERE, missingScriptError);
                result = missingScriptError;
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            catch (GroovyRuntimeException e2) {
                result = "Error in script or template: " + e2.toString();
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return result;
    }

    private String generateMissingFile(String script, String template) {
        if (!StringUtils.isEmpty((String)script)) {
            return "Script [" + script + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
        }
        return "Template [" + template + "] was not found in $JENKINS_HOME/" + EMAIL_TEMPLATES_DIRECTORY + ".";
    }

    private InputStream getFileInputStream(String fileName) throws FileNotFoundException {
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hudson/plugins/emailext/templates/" + fileName);
        if (inputStream == null) {
            File scriptsFolder = new File(Hudson.getInstance().getRootDir(), EMAIL_TEMPLATES_DIRECTORY);
            File scriptFile = new File(scriptsFolder, fileName);
            inputStream = new FileInputStream(scriptFile);
        }
        return inputStream;
    }

    private String renderTemplate(AbstractBuild<?, ?> build, TaskListener listener, InputStream templateStream) throws IOException {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("build", build);
        binding.put("listener", listener);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("rooturl", ExtendedEmailPublisher.DESCRIPTOR.getHudsonUrl());
        binding.put("project", build.getParent());
        MethodMissingHandler handler = new MethodMissingHandler(build, listener);
        GroovyShell shell = this.createEngine(Collections.singletonMap("methodMissing", InvokerHelper.getMethodPointer((Object)handler, (String)"methodMissing")));
        shell.evaluate("Script.metaClass.methodMissing = methodMissing");
        SimpleTemplateEngine engine = new SimpleTemplateEngine(shell);
        return engine.createTemplate((Reader)new InputStreamReader(templateStream)).make(binding).toString();
    }

    private String executeScript(AbstractBuild<?, ?> build, TaskListener listener, InputStream scriptStream) throws IOException {
        String result = "";
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("build", build);
        binding.put("it", new ScriptContentBuildWrapper(build));
        binding.put("project", build.getParent());
        binding.put("rooturl", ExtendedEmailPublisher.DESCRIPTOR.getHudsonUrl());
        GroovyShell shell = this.createEngine(binding);
        Object res = shell.evaluate((Reader)new InputStreamReader(scriptStream));
        if (res != null) {
            result = res.toString();
        }
        return result;
    }

    private GroovyShell createEngine(Map<String, Object> variables) throws FileNotFoundException, IOException {
        ClassLoader cl = Jenkins.getInstance().getPluginManager().uberClassLoader;
        ScriptSandbox sandbox = null;
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"jenkins", "jenkins.model", "hudson", "hudson.model"})});
        if (ExtendedEmailPublisher.DESCRIPTOR.isSecurityEnabled()) {
            cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
            sandbox = new ScriptSandbox();
        }
        Binding binding = new Binding();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            binding.setVariable(e.getKey(), e.getValue());
        }
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        if (sandbox != null) {
            sandbox.register();
        }
        return shell;
    }

    public boolean hasNestedContent() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodMissingHandler {
        private AbstractBuild<?, ?> build;
        private TaskListener listener;

        public MethodMissingHandler(AbstractBuild<?, ?> build, TaskListener listener) {
            this.build = build;
            this.listener = listener;
        }

        private void populateArgs(Object args, Map<String, String> map, ListMultimap<String, String> multiMap) {
            Object[] argArray;
            if (args instanceof Object[] && (argArray = (Object[])args).length > 0) {
                Map argMap = (Map)argArray[0];
                for (Map.Entry entry : argMap.entrySet()) {
                    String value = entry.getValue().toString();
                    if (entry.getValue() instanceof List) {
                        List valueList = (List)entry.getValue();
                        for (Object v : valueList) {
                            multiMap.put(entry.getKey(), (Object)v.toString());
                        }
                        value = valueList.get(valueList.size() - 1).toString();
                    } else {
                        multiMap.put(entry.getKey(), (Object)value);
                    }
                    map.put((String)entry.getKey(), value);
                }
            }
        }

        public Object methodMissing(String name, Object args) throws MacroEvaluationException, IOException, InterruptedException {
            TokenMacro macro = null;
            for (TokenMacro m : TokenMacro.all()) {
                if (!m.acceptsMacroName(name)) continue;
                macro = m;
                break;
            }
            if (macro == null) {
                for (TokenMacro m : ContentBuilder.getPrivateMacros()) {
                    if (!m.acceptsMacroName(name)) continue;
                    macro = m;
                    break;
                }
            }
            if (macro != null) {
                HashMap<String, String> argsMap = new HashMap<String, String>();
                ArrayListMultimap argsMultimap = ArrayListMultimap.create();
                this.populateArgs(args, argsMap, (ListMultimap<String, String>)argsMultimap);
                return macro.evaluate(this.build, this.listener, name, argsMap, (ListMultimap)argsMultimap);
            }
            return String.format("[Could not find content token (check your usage): %s]", name);
        }
    }
}

