/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLogExcerptContent
implements EmailContent {
    private static final Logger LOGGER = Logger.getLogger(BuildLogExcerptContent.class.getName());

    @Override
    public String getToken() {
        return "BUILD_LOG_EXCERPT";
    }

    @Override
    public List<String> getArguments() {
        return Arrays.asList("start", "end");
    }

    @Override
    public String getHelpText() {
        return "Displays an excerpt from the build log.\n<ul>\n<li><i>start</i> - Regular expression to match the excerpt starting line (matching line is excluded). See <a href='http://download.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html'><i>java.util.regex.Pattern</i></a></li><li><i>end</i> - Regular expression to match the excerpt ending line (matching line is excluded)</li></ul>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) throws IOException, InterruptedException {
        String string;
        BufferedReader reader = new BufferedReader(new FileReader(build.getLogFile()));
        try {
            string = this.getContent(reader, args);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                return "";
            }
        }
        reader.close();
        return string;
    }

    String getContent(BufferedReader reader, Map<String, ?> args) throws IOException {
        Pattern start = Pattern.compile((String)args.get("start"));
        Pattern end = Pattern.compile((String)args.get("end"));
        StringBuilder buffer = new StringBuilder();
        String line = null;
        boolean started = false;
        while ((line = reader.readLine()) != null) {
            if (start.matcher(line = ConsoleNote.removeNotes((String)line)).matches()) {
                started = true;
                continue;
            }
            if (end.matcher(line).matches()) break;
            if (!started) continue;
            buffer.append(line).append('\n');
        }
        return buffer.toString();
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

