/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCountsContent
implements EmailContent {
    private static final String TOKEN = "TEST_COUNTS";
    private static final String VAR_ARG_NAME = "var";
    private static final String VAR_DEFAULT_VALUE = "total";

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Collections.singletonList(VAR_ARG_NAME);
    }

    @Override
    public String getHelpText() {
        return "Displays the number of tests.\n<ul>\n<li><i>var</i> - Defaults to \"total\".\n  <ul>\n    <li>total - the number of all tests. </li>\n    <li>pass - the number of passed tests. </li>\n    <li>fail - the number of failed tests.</li>\n    <li>skip - the number of skipped tests.</li> \n  </ul>\n</li>\n</ul>\n";
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }

    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) throws IOException, InterruptedException {
        AbstractTestResultAction action = build.getTestResultAction();
        if (action == null) {
            return "";
        }
        String arg = EmailContent.Args.get(args, VAR_ARG_NAME, VAR_DEFAULT_VALUE).toLowerCase();
        if (VAR_DEFAULT_VALUE.equals(arg)) {
            return String.valueOf(action.getTotalCount());
        }
        if ("pass".equals(arg)) {
            return String.valueOf(action.getTotalCount() - action.getFailCount() - action.getSkipCount());
        }
        if ("fail".equals(arg)) {
            return String.valueOf(action.getFailCount());
        }
        if ("skip".equals(arg)) {
            return String.valueOf(action.getSkipCount());
        }
        return "";
    }
}

