/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailRecipientUtils {
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";
    public static final int TO = 0;
    public static final int CC = 1;

    public Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars) throws AddressException {
        return this.convertRecipientString(recipientList, envVars, 0);
    }

    public Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars, int type) throws AddressException {
        LinkedHashSet<InternetAddress> internetAddresses = new LinkedHashSet<InternetAddress>();
        if (!StringUtils.isBlank((String)recipientList)) {
            String expandedRecipientList = envVars.expand(recipientList);
            String[] addresses = StringUtils.trim((String)expandedRecipientList).split(COMMA_SEPARATED_SPLIT_REGEXP);
            String defaultSuffix = Mailer.descriptor().getDefaultSuffix();
            for (String address : addresses) {
                if (StringUtils.isBlank((String)address)) continue;
                boolean isCc = false;
                address = address.trim();
                isCc = address.startsWith("cc:");
                if (!address.contains("@") && defaultSuffix != null && defaultSuffix.contains("@")) {
                    address = address + defaultSuffix;
                }
                if (isCc) {
                    address = address.substring(3);
                }
                if ((type != 0 || isCc) && (type != 1 || !isCc)) continue;
                internetAddresses.add(new InternetAddress(address));
            }
        }
        return internetAddresses;
    }

    public FormValidation validateFormRecipientList(String recipientList) {
        try {
            this.convertRecipientString(recipientList, new EnvVars(), 0);
            this.convertRecipientString(recipientList, new EnvVars(), 1);
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)(e.getMessage() + ": \"" + e.getRef() + "\""));
        }
    }
}

