/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.emailext.EmailExtException;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.Util;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.tasks.Mailer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentBuilder {
    private static final Logger LOGGER = Logger.getLogger(Mailer.class.getName());
    private static final String DEFAULT_BODY = "\\$DEFAULT_CONTENT|\\$\\{DEFAULT_CONTENT\\}";
    private static final String DEFAULT_SUBJECT = "\\$DEFAULT_SUBJECT|\\$\\{DEFAULT_SUBJECT\\}";
    private static final String DEFAULT_RECIPIENTS = "\\$DEFAULT_RECIPIENTS|\\$\\{DEFAULT_RECIPIENTS\\}";
    private static final String PROJECT_DEFAULT_BODY = "\\$PROJECT_DEFAULT_CONTENT|\\$\\{PROJECT_DEFAULT_CONTENT\\}";
    private static final String PROJECT_DEFAULT_SUBJECT = "\\$PROJECT_DEFAULT_SUBJECT|\\$\\{PROJECT_DEFAULT_SUBJECT\\}";
    private static final Map<String, EmailContent> EMAIL_CONTENT_TYPE_MAP = new LinkedHashMap<String, EmailContent>();

    public static void addEmailContentType(EmailContent contentType) throws EmailExtException {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            throw new EmailExtException("An email content type with token name " + contentType.getToken() + " was already added.");
        }
        EMAIL_CONTENT_TYPE_MAP.put(contentType.getToken(), contentType);
    }

    public static void removeEmailContentType(EmailContent contentType) {
        if (EMAIL_CONTENT_TYPE_MAP.containsKey(contentType.getToken())) {
            EMAIL_CONTENT_TYPE_MAP.remove(contentType);
        }
    }

    public static EmailContent getEmailContentType(String token) {
        return EMAIL_CONTENT_TYPE_MAP.get(token);
    }

    public static Collection<EmailContent> getEmailContentTypes() {
        return EMAIL_CONTENT_TYPE_MAP.values();
    }

    private String noNull(String string) {
        return string == null ? "" : string;
    }

    public String transformText(String origText, ExtendedEmailPublisher publisher, EmailType type, AbstractBuild<?, ?> build) {
        String defaultContent = Matcher.quoteReplacement(this.noNull(publisher.defaultContent));
        String defaultSubject = Matcher.quoteReplacement(this.noNull(publisher.defaultSubject));
        String defaultBody = Matcher.quoteReplacement(this.noNull(ExtendedEmailPublisher.DESCRIPTOR.getDefaultBody()));
        String defaultExtSubject = Matcher.quoteReplacement(this.noNull(ExtendedEmailPublisher.DESCRIPTOR.getDefaultSubject()));
        String defaultRecipients = Matcher.quoteReplacement(this.noNull(ExtendedEmailPublisher.DESCRIPTOR.getDefaultRecipients()));
        String newText = origText.replaceAll(PROJECT_DEFAULT_BODY, defaultContent).replaceAll(PROJECT_DEFAULT_SUBJECT, defaultSubject).replaceAll(DEFAULT_BODY, defaultBody).replaceAll(DEFAULT_SUBJECT, defaultExtSubject).replaceAll(DEFAULT_RECIPIENTS, defaultRecipients);
        newText = ContentBuilder.replaceTokensWithContent(newText, publisher, type, build);
        return newText;
    }

    private static <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String replaceTokensWithContent(String origText, ExtendedEmailPublisher publisher, EmailType type, AbstractBuild<P, B> build) {
        StringBuffer sb = new StringBuffer();
        Tokenizer tokenizer = new Tokenizer(origText);
        while (tokenizer.find()) {
            String replacement;
            String tokenName = tokenizer.getTokenName();
            Map<String, Object> args = tokenizer.getArgs();
            EmailContent content = EMAIL_CONTENT_TYPE_MAP.get(tokenName);
            if (content != null) {
                try {
                    replacement = content.getContent(build, publisher, type, args);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Exception thrown while replacing " + tokenizer.group(), e);
                    replacement = "[[ Exception while replacing " + tokenName + ". Please report this as a bug. ]]\n";
                    replacement = replacement + "{{ " + e.toString() + " }}";
                }
                if (content.hasNestedContent()) {
                    replacement = ContentBuilder.replaceTokensWithContent(replacement, publisher, type, build);
                }
            } else {
                replacement = tokenizer.group();
            }
            tokenizer.appendReplacement(sb, replacement);
        }
        tokenizer.appendTail(sb);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Tokenizer {
        private static final String tokenNameRegex = "[a-zA-Z0-9_]+";
        private static final String numberRegex = "-?[0-9]+(\\.[0-9]*)?";
        private static final String boolRegex = "(true)|(false)";
        private static final String stringRegex = "\"([^\\\\\"\\r\\n]|(\\\\.))*\"";
        private static final String valueRegex = "(-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\.))*\")";
        private static final String spaceRegex = "[ \\t]*";
        private static final String argRegex = "([a-zA-Z0-9_]+)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\.))*\"))";
        private static final String argsRegex = "(([ \\t]*,[ \\t]*([a-zA-Z0-9_]+)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\.))*\")))*)";
        private static final String delimitedTokenRegex = "\\{[ \\t]*([a-zA-Z0-9_]+)(([ \\t]*,[ \\t]*([a-zA-Z0-9_]+)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\.))*\")))*)[ \\t]*\\}";
        private static final String tokenRegex = "\\$(([a-zA-Z0-9_]+)|(\\{[ \\t]*([a-zA-Z0-9_]+)(([ \\t]*,[ \\t]*([a-zA-Z0-9_]+)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\.))*\")))*)[ \\t]*\\}))";
        private static final Pattern argPattern = Pattern.compile("([a-zA-Z0-9_]+)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\.))*\"))");
        private static final Pattern tokenPattern = Pattern.compile("\\$(([a-zA-Z0-9_]+)|(\\{[ \\t]*([a-zA-Z0-9_]+)(([ \\t]*,[ \\t]*([a-zA-Z0-9_]+)[ \\t]*=[ \\t]*((-?[0-9]+(\\.[0-9]*)?)|((true)|(false))|(\"([^\\\\\"\\r\\n]|(\\\\.))*\")))*)[ \\t]*\\}))");
        private final Matcher tokenMatcher;
        private String tokenName = null;
        private Map<String, Object> args = null;

        Tokenizer(String origText) {
            this.tokenMatcher = tokenPattern.matcher(origText);
        }

        String getTokenName() {
            return this.tokenName;
        }

        Map<String, Object> getArgs() {
            return this.args;
        }

        String group() {
            return this.tokenMatcher.group();
        }

        boolean find() {
            if (this.tokenMatcher.find()) {
                this.tokenName = this.tokenMatcher.group(2);
                if (this.tokenName == null) {
                    this.tokenName = this.tokenMatcher.group(4);
                }
                this.args = new HashMap<String, Object>();
                if (this.tokenMatcher.group(5) != null) {
                    Tokenizer.parseArgs(this.tokenMatcher.group(5), this.args);
                }
                return true;
            }
            return false;
        }

        static void parseArgs(String argsString, Map<String, Object> args) {
            Matcher argMatcher = argPattern.matcher(argsString);
            while (argMatcher.find()) {
                Object arg = argMatcher.group(3) != null ? (argMatcher.group(4) != null ? (Number)Float.valueOf(argMatcher.group(3)) : (Number)Integer.valueOf(argMatcher.group(3))) : (argMatcher.group(5) != null ? (argMatcher.group(6) != null ? Boolean.TRUE : Boolean.FALSE) : Util.unescapeString(argMatcher.group(8)));
                args.put(argMatcher.group(1), arg);
            }
        }

        void appendReplacement(StringBuffer sb, String replacement) {
            this.tokenMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }

        void appendTail(StringBuffer sb) {
            this.tokenMatcher.appendTail(sb);
        }
    }
}

