/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.EnvVars;
import hudson.util.FormValidation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailRecepientUtils {
    public static final String COMMA_SEPARATED_SPLIT_REGEXP = "[,\\s]+";

    public Set<InternetAddress> convertRecipientString(String recipientList, EnvVars envVars) throws AddressException {
        String[] addresses;
        LinkedHashSet<InternetAddress> internetAddresses = new LinkedHashSet<InternetAddress>();
        if (StringUtils.isBlank((String)recipientList)) {
            return internetAddresses;
        }
        String expandedRecipientList = envVars.expand(recipientList);
        for (String address : addresses = StringUtils.trim((String)expandedRecipientList).split(COMMA_SEPARATED_SPLIT_REGEXP)) {
            if (address.trim().length() <= 0) continue;
            internetAddresses.add(new InternetAddress(address));
        }
        return internetAddresses;
    }

    public FormValidation validateFormRecipientList(String recipientList) {
        try {
            this.convertRecipientString(recipientList, new EnvVars());
            return FormValidation.ok();
        }
        catch (AddressException e) {
            return FormValidation.error((String)(e.getMessage() + ": \"" + e.getRef() + "\""));
        }
    }
}

