/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatusContent
implements EmailContent {
    private static final String TOKEN = "BUILD_STATUS";

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Collections.emptyList();
    }

    @Override
    public String getHelpText() {
        return "Displays the status of the current build. (failing, success, etc...)";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) {
        if (build.isBuilding()) {
            return "Building";
        }
        Result buildResult = build.getResult();
        if (buildResult == Result.FAILURE) {
            AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
            if (prevBuild == null || prevBuild.getResult() != Result.FAILURE) return "Failure";
            return "Still Failing";
        }
        if (buildResult == Result.UNSTABLE) {
            AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
            if (prevBuild == null) return "Unstable";
            if (prevBuild.getResult() == Result.UNSTABLE) {
                return "Still Unstable";
            }
            if (prevBuild.getResult() == Result.SUCCESS) {
                return "Unstable";
            }
            if (prevBuild.getResult() != Result.FAILURE && prevBuild.getResult() != Result.ABORTED && prevBuild.getResult() != Result.NOT_BUILT) return "Unknown";
            for (AbstractBuild previous = (AbstractBuild)prevBuild.getPreviousBuild(); previous != null; previous = (AbstractBuild)previous.getPreviousBuild()) {
                if (previous.getResult() == Result.SUCCESS) {
                    return "Unstable";
                }
                if (previous.getResult() != Result.UNSTABLE) continue;
                return "Still unstable";
            }
            return "Unstable";
        }
        if (buildResult != Result.SUCCESS) return "Unknown";
        AbstractBuild prevBuild = (AbstractBuild)build.getPreviousBuild();
        if (prevBuild == null || prevBuild.getResult() != Result.UNSTABLE && prevBuild.getResult() != Result.FAILURE) return "Successful";
        return "Fixed";
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

