/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.content;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Environment;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.emailext.EmailType;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.plugins.EmailContent;
import hudson.slaves.NodeProperty;
import hudson.tasks.BuildWrapper;
import hudson.util.NullStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvContent
implements EmailContent {
    private static final String TOKEN = "ENV";
    private static final String VAR_ARG_NAME = "var";
    private static final String VAR_DEFAULT_VALUE = "";

    @Override
    public String getToken() {
        return TOKEN;
    }

    @Override
    public List<String> getArguments() {
        return Collections.singletonList(VAR_ARG_NAME);
    }

    @Override
    public String getHelpText() {
        return "Displays an environment variable.\n<ul>\n<li><i>var</i> - the name of the environment variable to display.  If \"\", show all.<br>\nDefaults to \"\".\n</ul>\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends AbstractProject<P, B>, B extends AbstractBuild<P, B>> String getContent(AbstractBuild<P, B> build, ExtendedEmailPublisher publisher, EmailType emailType, Map<String, ?> args) throws IOException, InterruptedException {
        String var = EmailContent.Args.get(args, VAR_ARG_NAME, VAR_DEFAULT_VALUE);
        final ArrayList<Environment> buildEnvironments = new ArrayList<Environment>();
        Node node = build.getBuiltOn();
        if (node == null) {
            node = Hudson.getInstance();
        }
        StreamBuildListener listener = new StreamBuildListener((OutputStream)new NullStream());
        Launcher launcher = node.createLauncher((TaskListener)listener);
        try {
            EnvVars env;
            EnvironmentContributingAction environmentAction;
            block15: {
                Object environment;
                for (NodeProperty nodeProperty : Hudson.getInstance().getGlobalNodeProperties()) {
                    environment = nodeProperty.setUp(build, launcher, (BuildListener)listener);
                    if (environment == null) continue;
                    buildEnvironments.add((Environment)environment);
                }
                for (NodeProperty nodeProperty : node.getNodeProperties()) {
                    environment = nodeProperty.setUp(build, launcher, (BuildListener)listener);
                    if (environment == null) continue;
                    buildEnvironments.add((Environment)environment);
                }
                if (build.getProject() instanceof BuildableItemWithBuildWrappers) {
                    for (BuildWrapper wrapper : ((BuildableItemWithBuildWrappers)build.getProject()).getBuildWrappersList()) {
                        if (!"hudson.plugins.setenv.SetEnvBuildWrapper".equals(wrapper.getClass().getName()) || (environment = wrapper.setUp(build, launcher, (BuildListener)listener)) == null) continue;
                        buildEnvironments.add((Environment)environment);
                    }
                }
                environmentAction = new EnvironmentContributingAction(){

                    public void buildEnvVars(AbstractBuild<?, ?> build, EnvVars env) {
                        for (Environment environment : buildEnvironments) {
                            environment.buildEnvVars((Map)env);
                        }
                    }

                    public String getDisplayName() {
                        return null;
                    }

                    public String getIconFileName() {
                        return null;
                    }

                    public String getUrlName() {
                        return null;
                    }
                };
                try {
                    build.getActions().add(environmentAction);
                    env = build.getEnvironment((TaskListener)listener);
                    if (var.length() != 0) break block15;
                    environment = env.toString();
                    build.getActions().remove(environmentAction);
                }
                catch (Throwable throwable) {
                    build.getActions().remove(environmentAction);
                    throw throwable;
                }
                return environment;
            }
            String value = (String)env.get(var);
            if (value == null) {
                value = VAR_DEFAULT_VALUE;
            }
            String string = value;
            build.getActions().remove(environmentAction);
            return string;
        }
        finally {
            for (Environment environment : buildEnvironments) {
                environment.tearDown(build, (BuildListener)listener);
            }
        }
    }

    @Override
    public boolean hasNestedContent() {
        return false;
    }
}

