/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.CdJobOutcome;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.CdJobStatus;
import org.jenkinsci.plugins.electricflow.models.cdrestdata.jobs.FlowRuntimeResponseData;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GetJobStatusResponseData
implements FlowRuntimeResponseData {
    @JsonProperty
    private String jobId;
    @JsonProperty
    private CdJobStatus status = CdJobStatus.unknown;
    @JsonProperty
    private CdJobOutcome outcome = CdJobOutcome.unknown;
    private String content;

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public CdJobStatus getStatus() {
        return this.status;
    }

    public void setStatus(CdJobStatus status) {
        this.status = status;
    }

    public CdJobOutcome getOutcome() {
        return this.outcome;
    }

    public void setOutcome(CdJobOutcome outcome) {
        this.outcome = outcome;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        if ((this.getStatus() == CdJobStatus.unknown || this.getOutcome() == CdJobOutcome.unknown) && this.getContent() != null) {
            try {
                return "CD Job Status Response (unexpected json): " + Utils.formatJsonOutput(this.getContent());
            }
            catch (IOException e) {
                return "CD Job Status Response (unexpected content): " + this.getContent();
            }
        }
        return "CD Job Status Response Data: {jobId=" + this.jobId + ", status=" + (Object)((Object)this.status) + ", outcome=" + (Object)((Object)this.outcome) + '}';
    }

    @Override
    public Boolean isCompleted() {
        return this.status.equals((Object)CdJobStatus.completed);
    }

    @Override
    public String getRuntimeOutcome() {
        return this.getOutcome().toString();
    }

    @Override
    public String getRuntimeStatus() {
        return this.getStatus().toString();
    }

    @Override
    public String getRuntimeId() {
        return this.getJobId();
    }
}

