/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.extension.impl;

import hudson.plugins.git.GitChangeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.extension.CloudBeesFlowSCM;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"git"})
public class CloudBeesFlowSCMGit
extends CloudBeesFlowSCM {
    private static final Log log = LogFactory.getLog(CloudBeesFlowSCMGit.class);

    @Override
    public void populate(Object obj) {
        GitChangeSet object = (GitChangeSet)obj;
        this.setAuthor(object.getAuthorName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("CloudBeesFlowSCMGit:: Authorname is" + object.getAuthorName()));
        }
        this.setAuthorEmail(object.getAuthorEmail());
        this.setCommitId(object.getCommitId());
        this.setCommitMessage(object.getComment());
        if (log.isDebugEnabled()) {
            log.debug((Object)("CloudBeesFlowSCMGit:: Commit Message is" + object.getComment()));
        }
        this.setTimestamp(object.getTimestamp());
        this.setScmType("git");
    }

    @Override
    public CloudBeesFlowSCM generate() {
        CloudBeesFlowSCM retval = new CloudBeesFlowSCM();
        if (this.getAuthor() != null) {
            retval.setAuthor(this.getAuthor());
        }
        if (this.getAuthorEmail() != null) {
            retval.setAuthorEmail(this.getAuthorEmail());
        }
        if (this.getCommitMessage() != null) {
            retval.setCommitMessage(this.getCommitMessage());
        }
        if (this.getScmReportUrl() != null) {
            retval.setScmReportUrl(this.getScmReportUrl());
        }
        if (this.getScmType() != null) {
            retval.setScmType(this.getScmType());
        }
        if (this.getCommitId() != null) {
            retval.setCommitId(this.getCommitId());
        }
        retval.setTimestamp(this.getTimestamp());
        return retval;
    }

    @Override
    public boolean isApplicable(Object object) {
        return object instanceof GitChangeSet;
    }
}

