/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.extension;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Run;
import net.sf.json.JSONObject;

public class CloudBeesFlowTestResult
implements ExtensionPoint {
    protected int failCount;
    protected int failCountPrevious;
    protected int skipCount;
    protected int skipCountPrevious;
    protected int totalCount;
    protected int totalCountPrevious;
    protected double duration;
    protected double durationPrevious;
    protected String url;
    protected String displayName;
    protected boolean isPreviousRunExists = false;

    public static CloudBeesFlowTestResult build(Run run) {
        ExtensionList.lookup(CloudBeesFlowTestResult.class);
        ExtensionList makers = ExtensionList.lookup(CloudBeesFlowTestResult.class);
        for (CloudBeesFlowTestResult m : makers) {
            boolean popRes = m.populate(run);
            if (!popRes) continue;
            return m;
        }
        return null;
    }

    public JSONObject toJsonObject() {
        JSONObject json = new JSONObject();
        double durationSecs = 0.0;
        durationSecs = this.getDuration() * 1000.0;
        if (this.getUrl() != null) {
            json.put("url", (Object)this.getUrl());
        }
        json.put("displayName", (Object)this.getDisplayName());
        json.put("failCount", (Object)this.getFailCount());
        json.put("passCount", (Object)(this.getTotalCount() - this.getFailCount() - this.getSkipCount()));
        json.put("skipCount", (Object)this.getSkipCount());
        json.put("totalCount", (Object)this.getTotalCount());
        json.put("duration", (Object)durationSecs);
        if (this.isPreviousRunExists()) {
            double durationPreviousSecs = 0.0;
            durationPreviousSecs = this.getDurationPrevious() * 1000.0;
            json.put("failCountPrevious", (Object)this.getFailCountPrevious());
            json.put("passCountPrevious", (Object)(this.getTotalCountPrevious() - this.getFailCountPrevious() - this.getSkipCountPrevious()));
            json.put("skipCountPrevious", (Object)this.getSkipCountPrevious());
            json.put("totalCountPrevious", (Object)this.getTotalCountPrevious());
            json.put("durationPrevious", (Object)durationPreviousSecs);
        }
        return json;
    }

    public boolean isApplicable(Object object) {
        return false;
    }

    public boolean populate(Run<?, ?> run) {
        return false;
    }

    public int getFailCount() {
        return this.failCount;
    }

    public void setFailCount(int failCount) {
        this.failCount = failCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int skipCount) {
        this.skipCount = skipCount;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public int getFailCountPrevious() {
        return this.failCountPrevious;
    }

    public void setFailCountPrevious(int failCountPrevious) {
        this.failCountPrevious = failCountPrevious;
    }

    public int getSkipCountPrevious() {
        return this.skipCountPrevious;
    }

    public void setSkipCountPrevious(int skipCountPrevious) {
        this.skipCountPrevious = skipCountPrevious;
    }

    public int getTotalCountPrevious() {
        return this.totalCountPrevious;
    }

    public void setTotalCountPrevious(int totalCountPrevious) {
        this.totalCountPrevious = totalCountPrevious;
    }

    public double getDurationPrevious() {
        return this.durationPrevious;
    }

    public void setDurationPrevious(double durationPrevious) {
        this.durationPrevious = durationPrevious;
    }

    public boolean isPreviousRunExists() {
        return this.isPreviousRunExists;
    }

    public void setPreviousRunExists(boolean previousRunExists) {
        this.isPreviousRunExists = previousRunExists;
    }
}

