/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.event;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.Configuration;
import org.jenkinsci.plugins.electricflow.ElectricFlowClient;
import org.jenkinsci.plugins.electricflow.Utils;
import org.jenkinsci.plugins.electricflow.action.CloudBeesCDPBABuildDetails;
import org.jenkinsci.plugins.electricflow.causes.EFCause;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowBuildData;
import org.jenkinsci.plugins.electricflow.factories.ElectricFlowClientFactory;
import org.jenkinsci.plugins.electricflow.models.CIBuildDetail;

@Extension
public class ElectricFlowBuildWatcher
extends RunListener<Run> {
    private static final Log log = LogFactory.getLog(ElectricFlowBuildWatcher.class);

    public ElectricFlowBuildWatcher() {
        super(Run.class);
    }

    public void onStarted(Run run, TaskListener listener) {
        this.sendBuildDetailsToInstanceImproved(run, listener);
    }

    public void onCompleted(Run run, TaskListener listener) {
        this.sendBuildDetailsToInstanceImproved(run, listener);
    }

    public List<Configuration> getConfigurations() {
        List<Configuration> configs = Utils.getConfigurations();
        ArrayList<Configuration> retval = new ArrayList<Configuration>();
        for (Configuration c : configs) {
            if (c.getDoNotSendBuildDetails()) continue;
            retval.add(c);
        }
        return retval;
    }

    public boolean sendBuildDetailsToInstanceImproved(Run<?, ?> run, TaskListener taskListener) {
        EFCause efCause = null;
        CloudBeesCDPBABuildDetails cdPBABuildDetails = null;
        try {
            efCause = (EFCause)run.getCause(EFCause.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (efCause == null) {
            cdPBABuildDetails = (CloudBeesCDPBABuildDetails)run.getAction(CloudBeesCDPBABuildDetails.class);
        }
        if (efCause == null && cdPBABuildDetails == null) {
            return false;
        }
        List<Configuration> cfgs = this.getConfigurations();
        if (cfgs.size() == 0) {
            return false;
        }
        for (Configuration tc : cfgs) {
            ElectricFlowClient electricFlowClient = new ElectricFlowClient(tc.getConfigurationName());
            CloudBeesFlowBuildData cbf = new CloudBeesFlowBuildData(run);
            CIBuildDetail details = null;
            if (efCause != null) {
                details = new CIBuildDetail(cbf, efCause.getProjectName());
                details.setFlowRuntimeId(efCause.getFlowRuntimeId());
                details.setAssociationType(CIBuildDetail.BuildAssociationType.TRIGGERED_BY_FLOW);
                details.setBuildTriggerSource(CIBuildDetail.BuildTriggerSource.FLOW);
                if (!efCause.getStageName().equals("null")) {
                    details.setStageName(efCause.getStageName());
                }
                if (!efCause.getFlowRuntimeStateId().equals("null")) {
                    details.setFlowRuntimeStateId(efCause.getFlowRuntimeStateId());
                }
            } else if (cdPBABuildDetails != null) {
                if (cdPBABuildDetails.getOverriddenCredential() != null) {
                    electricFlowClient = ElectricFlowClientFactory.getElectricFlowClient(tc.getConfigurationName(), cdPBABuildDetails.getOverriddenCredential(), null, true);
                }
                if (cdPBABuildDetails.getConfigurationName() != null && !cdPBABuildDetails.getConfigurationName().equals(tc.getConfigurationName())) continue;
                details = new CIBuildDetail(cbf, cdPBABuildDetails.getProjectName());
                details.setFlowRuntimeId(cdPBABuildDetails.getFlowRuntimeId());
                if (cdPBABuildDetails.getBuildAssociationType() != null) {
                    details.setAssociationType(cdPBABuildDetails.getBuildAssociationType());
                } else {
                    details.setAssociationType(CIBuildDetail.BuildAssociationType.TRIGGERED_BY_CI);
                }
                if (cdPBABuildDetails.getTriggerSource() != null) {
                    details.setBuildTriggerSource(cdPBABuildDetails.getTriggerSource());
                }
                if (!cdPBABuildDetails.getStageName().equals("null")) {
                    details.setStageName(cdPBABuildDetails.getStageName());
                }
                if (!cdPBABuildDetails.getFlowRuntimeStateId().equals("null")) {
                    details.setFlowRuntimeStateId(cdPBABuildDetails.getFlowRuntimeStateId());
                }
            }
            if (details == null) continue;
            try {
                if (log.isDebugEnabled()) {
                    taskListener.getLogger().printf("Sending Build Details to CD:%n%s%n", details.toString());
                }
                JSONObject attachResult = electricFlowClient.attachCIBuildDetails(details);
                if (!log.isDebugEnabled()) continue;
                taskListener.getLogger().printf("Send Build Details execution result:%n%s%n", attachResult.toString());
            }
            catch (IOException e) {
            }
            catch (RuntimeException ex) {
                taskListener.getLogger().printf("Sent Build Details to CD:%n%s%n", details.toString());
                taskListener.getLogger().printf("[Configuration %s] Can't attach CiBuildData%n", tc.getConfigurationName());
                taskListener.getLogger().println(ex.getMessage());
            }
        }
        return true;
    }
}

