/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow.data;

import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jenkinsci.plugins.electricflow.causes.EFCause;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowArtifactData;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowPipelineData;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowSCMData;
import org.jenkinsci.plugins.electricflow.data.CloudBeesFlowTestResultData;
import org.jenkinsci.plugins.electricflow.extension.CloudBeesFlowArtifact;
import org.jenkinsci.plugins.electricflow.extension.CloudBeesFlowMultiBranchPipeline;
import org.jenkinsci.plugins.electricflow.extension.CloudBeesFlowPipeline;
import org.jenkinsci.plugins.electricflow.extension.CloudBeesFlowSCM;
import org.jenkinsci.plugins.electricflow.extension.CloudBeesFlowTestResult;

public class CloudBeesFlowBuildData {
    private static final Log log = LogFactory.getLog(CloudBeesFlowBuildData.class);
    protected String jobName;
    protected String displayName;
    protected String launchedBy;
    protected int buildNumber;
    protected boolean building;
    protected String result;
    protected String reason;
    protected long duration;
    protected long estimatedDuration;
    protected long timestamp;
    protected String logs;
    protected String url;
    protected String blueOceanUrl;
    protected String branchName;
    protected CloudBeesFlowPipelineData stages;
    protected CloudBeesFlowSCMData changeSets;
    protected CloudBeesFlowArtifactData artifacts;
    protected CloudBeesFlowTestResultData testResult;

    public CloudBeesFlowBuildData(Run<?, ?> run) {
        long duration;
        List causes;
        this.jobName = (String)run.getCharacteristicEnvVars().get((Object)"JOB_NAME");
        Jenkins instance = Jenkins.get();
        String rootUrl = instance.getRootUrl();
        this.setBuildNumber(run.getNumber());
        this.setDisplayName(run.getFullDisplayName());
        this.setBuilding(run.isBuilding());
        try {
            List runLogs = run.getLog(200);
            String logLines = String.join((CharSequence)"\n", runLogs);
            this.setLogs(logLines);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        Result result = run.getResult();
        if (result != null) {
            this.setResult(result.toString());
        }
        if (!(causes = run.getCauses()).isEmpty()) {
            EFCause efCause = (EFCause)run.getCause(EFCause.class);
            if (efCause != null) {
                this.setLaunchedBy(efCause.getLaunchedByText());
            } else if (causes.stream().findFirst().isPresent()) {
                Cause cause = (Cause)causes.stream().findFirst().get();
                this.setLaunchedBy(cause.getShortDescription());
            } else {
                this.setLaunchedBy("");
            }
        }
        if ((duration = run.getDuration()) == 0L) {
            duration = Math.max(System.currentTimeMillis() - run.getStartTimeInMillis(), 0L);
        }
        this.setDuration(duration);
        this.setEstimatedDuration(run.getEstimatedDuration());
        this.setTimestamp(run.getTimestamp().getTimeInMillis());
        this.setUrl(rootUrl + run.getUrl());
        RunWithSCM abstractBuild = (RunWithSCM)run;
        List changeSets = abstractBuild.getChangeSets();
        CloudBeesFlowMultiBranchPipeline multiBranchPipeline = CloudBeesFlowMultiBranchPipeline.build(run);
        this.setBranchName(multiBranchPipeline.getScmBranchName());
        this.changeSets = new CloudBeesFlowSCMData(changeSets);
        this.testResult = new CloudBeesFlowTestResultData(run);
        this.artifacts = new CloudBeesFlowArtifactData(run);
        this.stages = new CloudBeesFlowPipelineData(run);
    }

    public JSONObject toJsonObject() {
        CloudBeesFlowSCMData scmData;
        CloudBeesFlowTestResultData testResultData;
        CloudBeesFlowArtifactData artifactsData;
        CloudBeesFlowPipelineData pipelineData;
        JSONObject json = new JSONObject();
        if (this.getDisplayName() != null) {
            json.put("displayName", (Object)this.getDisplayName());
        }
        if (this.getLaunchedBy() != null) {
            json.put("launchedBy", (Object)this.getLaunchedBy());
        }
        json.put("buildNumber", (Object)Integer.toString(this.getBuildNumber()));
        json.put("building", (Object)this.isBuilding());
        if (this.getResult() != null) {
            json.put("result", (Object)this.getResult());
        }
        if (this.getReason() != null) {
            json.put("reason", (Object)this.getReason());
        }
        json.put("duration", (Object)this.getDuration());
        json.put("estimatedDuration", (Object)this.getEstimatedDuration());
        json.put("timestamp", (Object)this.getTimestamp());
        if (this.getLogs() != null) {
            json.put("logs", (Object)this.getLogs());
        }
        if (this.getUrl() != null) {
            json.put("url", (Object)this.getUrl());
            this.blueOceanUrl = this.getUrl().replace("job/" + this.jobName, "blue/organizations/jenkins/" + this.jobName + "/detail/" + this.jobName);
            json.put("consoleLogUrl", (Object)(this.getUrl() + "console"));
            json.put("blueOceanUrl", (Object)this.blueOceanUrl);
        }
        if (this.getBranchName() != null && !this.getBranchName().equals("")) {
            json.put("ciJobBranchName", (Object)this.getBranchName());
        }
        if ((pipelineData = this.getStages()) != null && pipelineData.getPipelineData() != null && pipelineData.getPipelineData().size() > 0) {
            JSONArray pipelineJsonArray = new JSONArray();
            List<CloudBeesFlowPipeline> pipelineRows = pipelineData.getPipelineData();
            for (int i = 0; i < pipelineRows.size(); ++i) {
                pipelineJsonArray.add((Object)pipelineRows.get(i).toJsonObject());
            }
            json.put("stage", (Object)pipelineJsonArray);
        }
        if ((artifactsData = this.getArtifacts()) != null && artifactsData.getArtifactData() != null && artifactsData.getArtifactData().size() > 0) {
            JSONArray artifactsJsonArray = new JSONArray();
            List<CloudBeesFlowArtifact> artifactRows = artifactsData.getArtifactData();
            for (int i = 0; i < artifactRows.size(); ++i) {
                artifactsJsonArray.add((Object)artifactRows.get(i).toJsonObject());
            }
            json.put("artifacts", (Object)artifactsJsonArray);
        }
        if ((testResultData = this.getTestResult()) != null && testResultData.getTestResultData() != null && testResultData.getTestResultData().size() > 0) {
            JSONArray testResultsJsonArray = new JSONArray();
            List<CloudBeesFlowTestResult> testResultRows = testResultData.getTestResultData();
            for (int i = 0; i < testResultRows.size(); ++i) {
                testResultsJsonArray.add((Object)testResultRows.get(i).toJsonObject());
            }
            json.put("testResult", (Object)testResultsJsonArray);
        }
        if ((scmData = this.getChangeSets()) != null && scmData.getScmData().size() > 0) {
            JSONArray scmJsonArray = new JSONArray();
            List<CloudBeesFlowSCM> scmRows = scmData.getScmData();
            for (int i = 0; i < scmRows.size(); ++i) {
                scmJsonArray.add((Object)scmRows.get(i).toJsonObject());
            }
            json.put("changeSets", (Object)scmJsonArray);
        }
        return json;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getLaunchedBy() {
        return this.launchedBy;
    }

    public void setLaunchedBy(String launchedBy) {
        this.launchedBy = launchedBy;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void setBuilding(boolean building) {
        this.building = building;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public void setEstimatedDuration(long estimatedDuration) {
        this.estimatedDuration = estimatedDuration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getLogs() {
        return this.logs;
    }

    public void setLogs(String logs) {
        this.logs = logs;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public CloudBeesFlowPipelineData getStages() {
        return this.stages;
    }

    public void setStages(CloudBeesFlowPipelineData stages) {
        this.stages = stages;
    }

    public CloudBeesFlowSCMData getChangeSets() {
        return this.changeSets;
    }

    public void setChangeSets(CloudBeesFlowSCMData changeSets) {
        this.changeSets = changeSets;
    }

    public CloudBeesFlowArtifactData getArtifacts() {
        return this.artifacts;
    }

    public void setArtifacts(CloudBeesFlowArtifactData artifacts) {
        this.artifacts = artifacts;
    }

    public CloudBeesFlowTestResultData getTestResult() {
        return this.testResult;
    }

    public void setTestResult(CloudBeesFlowTestResultData testResult) {
        this.testResult = testResult;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }
}

