/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.electricflow;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.electricflow.EnvReplacer;
import org.kohsuke.stapler.DataBoundConstructor;

public class Credential
extends AbstractDescribableImpl<Credential> {
    private String credentialId;

    @DataBoundConstructor
    public Credential(String credentialId) {
        this.credentialId = credentialId;
    }

    private static StandardUsernamePasswordCredentials getStandardUsernamePasswordCredentialsById(String credentialsId) {
        if (credentialsId == null) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new SchemeRequirement("http"), new SchemeRequirement("https")}), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    private static StandardUsernamePasswordCredentials getStandardUsernamePasswordCredentialsByIdAndRun(String credentialsId, Run run) {
        if (credentialsId == null) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StandardUsernamePasswordCredentials.class, (Run)run, Collections.emptyList());
    }

    public String getCredentialId(EnvReplacer envReplacer) {
        return envReplacer == null ? this.getCredentialId() : envReplacer.expandEnv(this.getCredentialId());
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public StandardUsernamePasswordCredentials getUsernamePasswordBasedOnCredentialId(EnvReplacer envReplacer, Run run) {
        String credentialIdResolved = this.getCredentialId(envReplacer);
        return run == null ? Credential.getStandardUsernamePasswordCredentialsById(credentialIdResolved) : Credential.getStandardUsernamePasswordCredentialsByIdAndRun(credentialIdResolved, run);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Credential> {
        public static ListBoxModel doFillCredentialIdItems(Item item) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            if (!item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return new ListBoxModel();
            }
            return new StandardUsernameListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardUsernamePasswordCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }

        public String getDisplayName() {
            return "Credential";
        }
    }
}

