/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.elasticsearchquery;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ElasticsearchQueryBuilder
extends Builder
implements SimpleBuildStep {
    private static final FastDateFormat LOGSTASH_INDEX_FORMAT = FastDateFormat.getInstance((String)"yyyy.MM.dd");
    private static final String LOGSTASH_INDEX_PREFIX = "logstash-";
    private final String query;
    private final String aboveOrBelow;
    private final Long threshold;
    private final Long since;
    private final String units;

    @DataBoundConstructor
    public ElasticsearchQueryBuilder(String query, String aboveOrBelow, Long threshold, Long since, String units) {
        this.query = StringUtils.trim((String)query);
        this.aboveOrBelow = StringUtils.trim((String)aboveOrBelow);
        this.threshold = threshold;
        this.since = since;
        this.units = units;
    }

    public String getQuery() {
        return this.query;
    }

    public String getAboveOrBelow() {
        return this.aboveOrBelow;
    }

    public Long getThreshold() {
        return this.threshold;
    }

    public Long getSince() {
        return this.since;
    }

    public String getUnits() {
        return this.units;
    }

    private String buildLogstashIndexes(long past) {
        StringBuilder stringBuilder = new StringBuilder();
        String pastDateString = LOGSTASH_INDEX_FORMAT.format(new Date(past));
        Date currentDate = new Date();
        String currentDateString = LOGSTASH_INDEX_FORMAT.format(currentDate);
        stringBuilder.append(LOGSTASH_INDEX_PREFIX);
        stringBuilder.append(currentDateString);
        while (!currentDateString.equals(pastDateString)) {
            currentDate = DateUtils.addDays((Date)currentDate, (int)-1);
            currentDateString = LOGSTASH_INDEX_FORMAT.format(currentDate);
            stringBuilder.append(",");
            stringBuilder.append(LOGSTASH_INDEX_PREFIX);
            stringBuilder.append(currentDateString);
        }
        return stringBuilder.toString();
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        listener.getLogger().println("Query: " + this.query);
        listener.getLogger().println("Fail when: " + this.aboveOrBelow);
        listener.getLogger().println("Threshold: " + this.threshold);
        listener.getLogger().println("Since: " + this.since);
        listener.getLogger().println("Time units: " + this.units);
        String user = this.getDescriptor().getUser();
        String password = this.getDescriptor().getPassword();
        if (StringUtils.isEmpty((String)user) != StringUtils.isEmpty((String)password)) {
            throw new AbortException("user and password must both be provided or empty! Please set value of user and password in Jenkins > Manage Jenkins > Configure System > Elasticsearch Query Builder");
        }
        String creds = StringUtils.isEmpty((String)user) ? "" : user + ":" + password + "@";
        String host = this.getDescriptor().getHost();
        listener.getLogger().println("host: " + host);
        if (StringUtils.isEmpty((String)host)) {
            throw new AbortException("Host cannot be empty! Please set value of host in Jenkins > Manage Jenkins > Configure System > ElasticSearch Query Builder");
        }
        Long past = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(this.since, TimeUnit.valueOf(this.units));
        String dateClause = " AND @timestamp:>=" + past;
        String queryIndexes = StringUtils.isNotBlank((String)this.getDescriptor().getIndexes()) ? this.getDescriptor().getIndexes() : this.buildLogstashIndexes(past);
        listener.getLogger().println("queryIndexes: " + queryIndexes);
        String url = null;
        try {
            url = "http" + (this.getDescriptor().getUseSSL() ? "s" : "") + "://" + creds + this.getDescriptor().getHost() + "/" + queryIndexes + "/_count?pretty=true&q=" + new URLCodec().encode(this.query + dateClause);
        }
        catch (EncoderException ee) {
            throw new RuntimeException(ee);
        }
        listener.getLogger().println("query url: " + url);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(url);
        Integer queryRequestTimeout = this.getDescriptor().getQueryRequestTimeout();
        HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)(queryRequestTimeout == null || queryRequestTimeout < 1 ? this.getDescriptor().defaultQueryRequestTimeout() : queryRequestTimeout));
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpget);
            listener.getLogger().println("response: " + response);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String content = null;
            Long count = null;
            InputStream instream = null;
            try {
                instream = entity.getContent();
                content = IOUtils.toString((InputStream)instream);
                listener.getLogger().println("content: " + content);
                Map map = (Map)new Gson().fromJson(content, new TypeToken<Map<String, Object>>(){}.getType());
                listener.getLogger().println("count: " + map.get("count"));
                count = Math.round((Double)map.get("count"));
            }
            catch (Exception ex) {
                httpget.abort();
                throw new RuntimeException(ex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)instream);
            }
            listener.getLogger().println("search url: " + StringUtils.replace((String)url, (String)"_count", (String)"_search"));
            String abortMessage = this.threshold + ". Failing build!\n" + "URL: " + url + "\n" + "response content: " + content;
            if (this.aboveOrBelow.equals("gte")) {
                if (count >= this.threshold) {
                    throw new AbortException("Count: " + count + " is >= " + abortMessage);
                }
            } else if (count <= this.threshold) {
                throw new AbortException("Count: " + count + " is <= " + abortMessage);
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String host;
        private String indexes;
        private String user;
        private String password;
        private boolean useSSL;
        private Integer queryRequestTimeout;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckQuery(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Please set a query");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckIndexes(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isNotBlank((String)value)) {
                if (!StringUtils.deleteWhitespace((String)value).equals(value)) {
                    return FormValidation.error((String)"Indexes cannot contain whitespace");
                }
                if (StringUtils.endsWith((String)value, (String)",")) {
                    return FormValidation.error((String)"Indexes cannot end with a comma");
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckThreshold(@QueryParameter String value) throws IOException, ServletException {
            if (!NumberUtils.isNumber((String)(value = StringUtils.trim((String)value))) || Long.parseLong(value) < 0L) {
                return FormValidation.error((String)"Please set a threshold greater than or equal to 0");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSince(@QueryParameter Long value) throws IOException, ServletException {
            if (value == null || value < 1L) {
                return FormValidation.error((String)"Please set a since value greater than 0");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQueryRequestTimeout(@QueryParameter Integer value) throws IOException, ServletException {
            if (value == null || value < 1) {
                return FormValidation.error((String)"Please set a value greater than 0");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillAboveOrBelowItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("gte");
            items.add("lte");
            return items;
        }

        public ListBoxModel doFillUnitsItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(TimeUnit.MINUTES.name());
            items.add(TimeUnit.HOURS.name());
            items.add(TimeUnit.DAYS.name());
            return items;
        }

        public Integer defaultQueryRequestTimeout() {
            return 120000;
        }

        public String getDisplayName() {
            return "Elasticsearch Query";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.host = StringUtils.trim((String)formData.getString("host"));
            this.indexes = StringUtils.trim((String)formData.getString("indexes"));
            this.user = formData.getString("user");
            this.password = StringUtils.trim((String)formData.getString("password"));
            this.useSSL = formData.getBoolean("useSSL");
            this.queryRequestTimeout = NumberUtils.toInt((String)StringUtils.trim((String)formData.getString("queryRequestTimeout")), (int)this.defaultQueryRequestTimeout());
            this.save();
            return super.configure(req, formData);
        }

        public String getHost() {
            return this.host;
        }

        public String getIndexes() {
            return this.indexes;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean getUseSSL() {
            return this.useSSL;
        }

        public Integer getQueryRequestTimeout() {
            return this.queryRequestTimeout;
        }
    }
}

