/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.utils;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import jenkins.plugins.elastest.utils.FileManager;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class ParseResultCallable
extends MasterToSlaveFileCallable<List<String>> {
    private static final long serialVersionUID = 1L;
    private final long buildTime;
    private final String testResults;
    private final long nowMaster;

    public ParseResultCallable(String testResults, long buildTime, long nowMaster) {
        this.buildTime = buildTime;
        this.testResults = testResults;
        this.nowMaster = nowMaster;
    }

    public List<String> invoke(File ws, VirtualChannel channel) throws IOException {
        long nowSlave = System.currentTimeMillis();
        FileManager fm = new FileManager();
        FileSet fs = fm.createFileSet(ws, this.testResults, null);
        DirectoryScanner ds = fs.getDirectoryScanner();
        List<String> result = null;
        String[] files = ds.getIncludedFiles();
        if (files.length > 0) {
            result = this.parse(this.buildTime + (nowSlave - this.nowMaster), ds.getBasedir(), ds.getIncludedFiles(), fm);
        }
        return result;
    }

    public List<String> parse(long buildTime, File baseDir, String[] reportFiles, FileManager fm) throws IOException {
        ArrayList<String> testReportsAsString = new ArrayList<String>();
        boolean parsed = false;
        for (String value : reportFiles) {
            File reportFile = new File(baseDir, value);
            if (buildTime - 3000L > reportFile.lastModified()) continue;
            testReportsAsString.add(fm.readFile(reportFile));
        }
        return testReportsAsString;
    }
}

