/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.utils;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.bind.DatatypeConverter;

public class Authenticator
implements ClientRequestFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private String user;
    private String password;
    private boolean usingSecurity;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUsingSecurity() {
        return this.usingSecurity;
    }

    public void setUsingSecurity(boolean usingSecurity) {
        this.usingSecurity = usingSecurity;
    }

    public Authenticator() {
    }

    public Authenticator(String user, String password) {
        this.setCredentials(user, password);
    }

    public void setCredentials(String newUser, String newPassword) {
        this.user = newUser;
        this.password = newPassword;
        this.usingSecurity = this.user != null && this.password != null;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        MultivaluedMap headers = requestContext.getHeaders();
        headers.add((Object)"ContentType", (Object)"application/json");
        if (this.usingSecurity) {
            String basicAuthentication = this.getBasicAuthentication();
            headers.add((Object)"Authorization", (Object)basicAuthentication);
        }
    }

    private String getBasicAuthentication() {
        String token = this.user + ":" + this.password;
        try {
            return "BASIC " + DatatypeConverter.printBase64Binary((byte[])token.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Cannot encode with UTF-8", ex);
        }
    }
}

