/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.submitters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.plugins.elastest.submitters.AbstractElasTestSubmitter;
import jenkins.plugins.elastest.submitters.ElasTestSubmitter;
import jenkins.plugins.elastest.submitters.LogstashSubmitter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public final class SubmitterFactory {
    private static AbstractElasTestSubmitter instance = null;
    private static final Map<ElasTestSubmitter.SubmitterType, Class<?>> INDEXER_MAP;

    public static synchronized ElasTestSubmitter getInstance(ElasTestSubmitter.SubmitterType type, String host, Integer port, String key, String username, String password) throws InstantiationException {
        if (type == null || !INDEXER_MAP.containsKey((Object)type)) {
            throw new InstantiationException("[elastest-plugin]: Unknown IndexerType '" + (Object)((Object)type) + "'. Did you forget to configure the plugin?");
        }
        Integer n = port = port == null ? Integer.valueOf(-1) : port;
        if (SubmitterFactory.shouldRefreshInstance(type, host, port, key, username, password)) {
            try {
                Class<?> indexerClass = INDEXER_MAP.get((Object)type);
                Constructor<?> constructor = indexerClass.getConstructor(String.class, Integer.TYPE, String.class, String.class, String.class);
                instance = (AbstractElasTestSubmitter)constructor.newInstance(host, port, key, username, password);
            }
            catch (NoSuchMethodException e) {
                throw new InstantiationException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            catch (InvocationTargetException e) {
                throw new InstantiationException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return instance;
    }

    private static boolean shouldRefreshInstance(ElasTestSubmitter.SubmitterType type, String host, int port, String key, String username, String password) {
        if (instance == null) {
            return true;
        }
        boolean matches = instance.getSubmitterType() == type && StringUtils.equals((String)SubmitterFactory.instance.host, (String)host) && SubmitterFactory.instance.port == port && StringUtils.equals((String)SubmitterFactory.instance.key, (String)key) && StringUtils.equals((String)SubmitterFactory.instance.username, (String)username) && StringUtils.equals((String)SubmitterFactory.instance.password, (String)password);
        return !matches;
    }

    static {
        HashMap<ElasTestSubmitter.SubmitterType, Class<LogstashSubmitter>> indexerMap = new HashMap<ElasTestSubmitter.SubmitterType, Class<LogstashSubmitter>>();
        indexerMap.put(ElasTestSubmitter.SubmitterType.LOGSTASH, LogstashSubmitter.class);
        INDEXER_MAP = Collections.unmodifiableMap(indexerMap);
    }
}

