/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.submitters;

import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import jenkins.plugins.elastest.submitters.AbstractElasTestSubmitter;
import jenkins.plugins.elastest.submitters.ElasTestSubmitter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogstashSubmitter
extends AbstractElasTestSubmitter {
    private final transient Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final HttpClientBuilder clientBuilder;
    final URI uri;
    final String auth;
    final Range<Integer> successCodes = Ranges.closedOpen((Comparable)Integer.valueOf(200), (Comparable)Integer.valueOf(300));

    public LogstashSubmitter(String host, int port, String key, String username, String password) {
        this(null, host, port, key, username, password);
    }

    LogstashSubmitter(HttpClientBuilder factory, String host, int port, String key, String username, String password) {
        super(host, port, key, username, password);
        this.logger.info("[elastest-plugin]: Creating a Logstash submitter.");
        try {
            this.uri = new URIBuilder("http://" + host).setPort(port).setPath("/" + key + "/").build();
            this.logger.info("[elastest-plugin]: Logstash URI: {}", (Object)this.uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create uri", e);
        }
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            this.logger.info("[elastest-plugin]: Using basic authentication.");
            this.auth = Base64.encodeBase64String((byte[])(username + ":" + StringUtils.defaultString((String)password)).getBytes(StandardCharsets.UTF_8));
        } else {
            this.auth = null;
        }
        this.clientBuilder = factory == null ? HttpClientBuilder.create() : factory;
    }

    HttpPost getHttpPost(String data) {
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        requestConfig.setConnectTimeout(3000);
        requestConfig.setConnectionRequestTimeout(3000);
        requestConfig.setSocketTimeout(3000);
        HttpPost postRequest = new HttpPost(this.uri);
        postRequest.setConfig(requestConfig.build());
        StringEntity input = new StringEntity(data, ContentType.APPLICATION_JSON);
        postRequest.setEntity((HttpEntity)input);
        if (this.auth != null) {
            postRequest.addHeader("Authorization", "Basic " + this.auth);
        }
        return postRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean push(String data) throws IOException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpPost post = this.getHttpPost(data);
        boolean sentMessage = false;
        try {
            httpClient = this.clientBuilder.build();
            response = httpClient.execute((HttpUriRequest)post);
            if (!this.successCodes.contains((Comparable)Integer.valueOf(response.getStatusLine().getStatusCode()))) {
                throw new IOException(this.getErrorMessage(response));
            }
            sentMessage = true;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            this.logger.error("[elastest-plugin]: Error sendind log trace message {} ", (Object)data);
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return sentMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrorMessage(CloseableHttpResponse response) {
        ByteArrayOutputStream byteStream = null;
        try (PrintStream stream = null;){
            byteStream = new ByteArrayOutputStream();
            stream = new PrintStream((OutputStream)byteStream, false, StandardCharsets.UTF_8.name());
            try {
                stream.print("HTTP error code: ");
                stream.println(response.getStatusLine().getStatusCode());
                stream.print("URI: ");
                stream.println(this.uri.toString());
                stream.println("RESPONSE: " + response.toString());
                response.getEntity().writeTo((OutputStream)stream);
            }
            catch (IOException e) {
                stream.println(ExceptionUtils.getStackTrace((Throwable)e));
            }
            stream.flush();
            String e = byteStream.toString(StandardCharsets.UTF_8.name());
            return e;
        }
    }

    @Override
    public ElasTestSubmitter.SubmitterType getSubmitterType() {
        return ElasTestSubmitter.SubmitterType.LOGSTASH;
    }
}

