/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.docker;

import java.io.Serializable;
import java.util.Arrays;
import jenkins.plugins.elastest.utils.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerService
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DockerService.class);
    private static final long serialVersionUID = 1L;
    public static final String DOCKER_HOST_BY_DEFAULT = "unix:///var/run/docker.sock";
    private static DockerService dockerService;

    public static synchronized DockerService getDockerService(String dockerHost) {
        if (dockerService != null) {
            return dockerService;
        }
        return new DockerService();
    }

    public String executeDockerCommand(String ... startCommand) {
        LOG.info("[elastest-plugin]: Docker command to execute: {}", (Object)Arrays.toString(startCommand));
        String result = Shell.runAndWait(startCommand).replaceAll("\n", "");
        return result;
    }

    public String getGatewayFromContainer(String containerName) {
        String gateway = null;
        gateway = this.executeDockerCommand("docker", "inspect", "--format=\\\"{{.NetworkSettings.Networks.elastest_elastest.Gateway}}\\\"", containerName);
        LOG.info("[elastest-plugin]: Docker network gateway: {}", (Object)gateway);
        return gateway.replaceAll("\\\\\"", "");
    }
}

