/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest.docker;

import java.util.Arrays;
import jenkins.plugins.elastest.docker.DockerService;
import jenkins.security.MasterToSlaveCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerCommandExecutor
extends MasterToSlaveCallable<String, RuntimeException> {
    private static final Logger LOG = LoggerFactory.getLogger(DockerCommandExecutor.class);
    private static final long serialVersionUID = 1L;
    private String[] command;
    private DockerService dockerService;

    public DockerCommandExecutor(String[] command, DockerService dockerService) {
        this.command = command != null ? (String[])command.clone() : null;
        this.dockerService = dockerService;
    }

    public String call() throws RuntimeException {
        LOG.debug("[elastest-plugin]: Executing docker command \" {} \" on a distributed node if necessary", (Object)Arrays.toString(this.command));
        String result = this.dockerService.executeDockerCommand(this.command);
        LOG.debug("Docker command output: {}", (Object)result);
        return result;
    }

    public String[] getCommand() {
        return (String[])this.command.clone();
    }

    public void setCommand(String ... command) {
        this.command = command;
    }
}

