/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest;

import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jenkins.model.Jenkins;
import jenkins.plugins.elastest.ElasTestInstallation;
import jenkins.plugins.elastest.action.ElasTestItemMenuAction;
import jenkins.plugins.elastest.json.ExternalJob;
import jenkins.plugins.elastest.submitters.ElasTestSubmitter;
import jenkins.plugins.elastest.submitters.SubmitterFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasTestWriter
implements Serializable {
    private static final long serialVersionUID = 1L;
    final transient Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    transient OutputStream errorStream;
    final transient Run<?, ?> build;
    final TaskListener listener;
    final String jenkinsUrl;
    final transient ElasTestSubmitter elastestSubmiter;
    private boolean connectionBroken;
    final ExternalJob externalJob;
    private transient ExecutorService executor;

    public ElasTestWriter(Run<?, ?> run, TaskListener listener, ExternalJob externalJob) {
        this.LOG.info("[elastest-plugin]: Creating ElasTestWriter");
        this.build = run;
        this.listener = listener;
        this.externalJob = externalJob;
        this.elastestSubmiter = this.getSubmitterOrNull(ElasTestSubmitter.SubmitterType.LOGSTASH);
        this.jenkinsUrl = this.elastestSubmiter == null ? "" : this.getJenkinsUrl();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void setErrorStream(OutputStream error) {
        this.errorStream = error != null ? error : System.err;
    }

    public void write(String line) {
        if (!this.isConnectionBroken() && StringUtils.isNotEmpty((String)line)) {
            this.write(Arrays.asList(line));
        }
    }

    public boolean isConnectionBroken() {
        return this.connectionBroken || this.build == null || this.elastestSubmiter == null;
    }

    ElasTestSubmitter getSubmitter(ElasTestSubmitter.SubmitterType type) throws InstantiationException {
        ElasTestInstallation.Descriptor descriptor = ElasTestInstallation.getLogstashDescriptor();
        String key = "";
        String host = "";
        Integer port = 0;
        if (type.compareTo(ElasTestSubmitter.SubmitterType.LOGSTASH) == 0) {
            this.LOG.info("[elastest-plugin]: ElasTest services ip ->" + this.externalJob.getServicesIp());
            if (this.externalJob.isFromIntegratedJenkins()) {
                if (this.externalJob.getServicesIp().equals("etm")) {
                    key = "api/monitoring";
                }
            } else {
                key = ElasTestSubmitter.SubmitterType.LOGSTASH.toString();
            }
            host = this.externalJob.getServicesIp();
            port = Integer.valueOf(this.externalJob.getLogstashPort());
            this.LOG.debug("[elastest-plugin]: LOGSTASH KEY -> {}", (Object)key);
            this.LOG.debug("[elastest-plugin]: LOGSTASH HOST -> {}", (Object)host);
            this.LOG.debug("[elastest-plugin]: LOGSTASH PORT -> {}", (Object)port);
        }
        return SubmitterFactory.getInstance(type, host, port, key, descriptor.username, descriptor.password);
    }

    String getJenkinsUrl() {
        return Jenkins.getInstance().getRootUrl();
    }

    private void write(List<String> lines) {
        if (this.build.getAction(ElasTestItemMenuAction.class) != null) {
            String payload = this.elastestSubmiter.buildPayload(lines, this.externalJob);
            this.LOG.debug("[elastest-plugin]: Message to send " + payload.toString());
            this.executor.execute(() -> this.sendPayload(payload));
        }
    }

    private ElasTestSubmitter getSubmitterOrNull(ElasTestSubmitter.SubmitterType type) {
        try {
            return this.getSubmitter(type);
        }
        catch (InstantiationException e) {
            String msg = ExceptionUtils.getMessage((Throwable)e) + "\n[logstash-plugin]: Unable to instantiate LogstashIndexerDao with current configuration.\n";
            this.logErrorMessage(msg);
            return null;
        }
    }

    public OutputStream getErrorStream() {
        return this.errorStream;
    }

    public Run<?, ?> getBuild() {
        return this.build;
    }

    public TaskListener getListener() {
        return this.listener;
    }

    public ExternalJob getExternalJob() {
        return this.externalJob;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    private void logErrorMessage(String msg) {
        try {
            this.errorStream.write(msg.getBytes(StandardCharsets.UTF_8));
            this.errorStream.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void sendPayload(String payload) {
        try {
            int maxAttempts = 4;
            int attempt = 0;
            boolean sended = false;
            while (attempt < maxAttempts && !sended) {
                if (attempt > 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.LOG.debug("[elastest-plugin]: Attempt to send {}", (Object)(++attempt));
                sended = this.elastestSubmiter.push(payload.toString());
            }
            if (attempt > 4 && !sended) {
                String msg = "[elastest-plugin]: Failed to send log data to " + (Object)((Object)this.elastestSubmiter.getSubmitterType()) + ":" + this.elastestSubmiter.getDescription() + ".\n";
                this.logErrorMessage(msg);
            }
        }
        catch (IOException e) {
            String msg = "[elastest-plugin]: Failed to send log data to " + (Object)((Object)this.elastestSubmiter.getSubmitterType()) + ":" + this.elastestSubmiter.getDescription() + ".\n" + ExceptionUtils.getStackTrace((Throwable)e);
            this.logErrorMessage(msg);
        }
    }
}

