/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.elastest;

import hudson.console.ConsoleNote;
import hudson.console.LineTransformationOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import jenkins.plugins.elastest.ElasTestWriter;

public class ElasTestOutputStream
extends LineTransformationOutputStream {
    final OutputStream delegate;
    final ElasTestWriter elasTestWriter;

    public ElasTestOutputStream(OutputStream delegate, ElasTestWriter elasTestWriter) {
        this.delegate = delegate;
        this.elasTestWriter = elasTestWriter;
    }

    protected void eol(byte[] b, int len) throws IOException {
        this.delegate.write(b, 0, len);
        this.flush();
        if (!this.elasTestWriter.isConnectionBroken()) {
            String line = new String(b, 0, len, StandardCharsets.UTF_8.name()).trim();
            line = ConsoleNote.removeNotes((String)line);
            this.elasTestWriter.write(line);
        }
    }

    public void flush() throws IOException {
        this.delegate.flush();
        super.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }
}

