/*
 * Decompiled with CFR 0.152.
 */
package eggPlant;

import eggPlant.EggPlantInstallation;
import eggPlant.EggplantParser;
import eggPlant.eggPlantAction;
import eggPlant.eggPlantResult;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class eggPlantBuilder
extends Builder {
    private final String script;
    private final String sut;
    private final String port;
    private final String password;
    private final String colorDepth;
    private final String globalResultsFolder;
    private final String defaultDocumentDirectory;
    private final String params;
    private final boolean reportFailures;
    private final boolean commandLineOutput;
    private String installationName;

    @DataBoundConstructor
    public eggPlantBuilder(String script, String SUT, String port, String password, String colorDepth, String globalResultsFolder, String defaultDocumentDirectory, String params, boolean reportFailures, boolean commandLineOutput, String installationName) {
        this.script = script;
        this.sut = SUT;
        this.port = port;
        this.password = password;
        this.colorDepth = colorDepth;
        this.globalResultsFolder = globalResultsFolder;
        this.defaultDocumentDirectory = defaultDocumentDirectory;
        this.params = params;
        this.reportFailures = reportFailures;
        this.commandLineOutput = commandLineOutput;
        this.installationName = installationName;
    }

    public String getPort() {
        return this.port;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSUT() {
        return this.sut;
    }

    public String getScript() {
        return this.script;
    }

    public String getColorDepth() {
        return this.colorDepth;
    }

    public boolean getCommandLineOutput() {
        return this.commandLineOutput;
    }

    public boolean getReportFailures() {
        return this.reportFailures;
    }

    public String getDefaultDocumentDirectory() {
        return this.defaultDocumentDirectory;
    }

    public String getInstallationName() {
        return this.installationName;
    }

    public String getGlobalResultsFolder() {
        return this.globalResultsFolder;
    }

    public String getParams() {
        return this.params;
    }

    private String getResolvedString(String str, AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
        if (str == null) {
            return null;
        }
        String resolvedStr = Util.replaceMacro((String)str, (Map)build.getEnvironment((TaskListener)listener));
        resolvedStr = Util.replaceMacro((String)resolvedStr, (Map)build.getBuildVariables());
        return resolvedStr;
    }

    EggPlantInstallation getInstallation(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        for (EggPlantInstallation i : this.getDescriptor().getInstallations()) {
            if (this.installationName == null || !this.installationName.equals(i.getName())) continue;
            return (EggPlantInstallation)i.translate(build, (TaskListener)listener);
        }
        return null;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        if (this.script == null || Util.fixEmptyAndTrim((String)this.script) == null) {
            log.println("Script name required for eggPlant execution.");
            return false;
        }
        log.println("eggPlant execution started");
        EggPlantInstallation installation = this.getInstallation(build, listener);
        if (installation == null) {
            log.println("eggPlant installation not found for this node.");
            return false;
        }
        String commandLine = installation.getHome();
        if (commandLine == null || commandLine.isEmpty()) {
            log.println("eggPlant runtime not defined.");
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(installation.getHome());
        try {
            FilePath[] results;
            this.prepArgs(args, build, listener);
            int returnVal = launcher.launch().cmds(args).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            if (returnVal != 0) {
                listener.finished(Result.FAILURE);
            }
            log.println("Runscript execution completed");
            log.println("Parsing results...");
            eggPlantAction action = (eggPlantAction)build.getAction(eggPlantAction.class);
            if (action == null) {
                action = new eggPlantAction(build);
                build.addAction((Action)action);
            }
            for (FilePath fp : results = build.getWorkspace().list("**/RunHistory.csv")) {
                log.println("Parsing results for test: " + fp.getParent().getName());
                List rList = (List)fp.act((FilePath.FileCallable)new EggplantParser(this.sut, build.getUrl()));
                action.getResultList().addAll(rList);
            }
            log.println("Finished parsing eggPlant results");
            ArrayList<eggPlantResult> resultsList = action.getResultList();
            for (eggPlantResult result : resultsList) {
                if (result.isPassed()) continue;
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            log.println(ex.getMessage());
            return false;
        }
        catch (InterruptedException ex) {
            log.println(ex.getMessage());
            return false;
        }
    }

    private void prepArgs(ArgumentListBuilder args, AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
        if (this.script.indexOf(44) > 0) {
            String[] scriptArray;
            for (String scr : scriptArray = this.script.split(",")) {
                args.add(scr);
            }
        } else {
            args.addTokenized(this.script);
        }
        if (!this.sut.isEmpty()) {
            args.add("-host");
            args.add(this.sut);
        }
        if (!this.port.isEmpty()) {
            args.add("-port");
            args.add(this.port);
        }
        if (!this.password.isEmpty()) {
            args.add("-password");
            args.add(this.password);
        }
        if (!this.colorDepth.isEmpty()) {
            args.add("-colorDepth");
            args.add(this.colorDepth);
        }
        if (this.reportFailures) {
            args.add("-ReportFailures");
            args.add("YES");
        }
        if (this.commandLineOutput) {
            args.add("-CommandLineOutput");
            args.add("YES");
        }
        if (!this.params.isEmpty()) {
            if (this.params.indexOf(44) > 0) {
                String[] parameters = this.params.split(",");
                for (int i = 0; i < parameters.length; ++i) {
                    args.add(parameters[i]);
                }
            } else {
                args.addTokenized(this.params);
            }
        }
        args.add("-DefaultDocumentDirectory");
        if (this.defaultDocumentDirectory.isEmpty()) {
            args.add(build.getWorkspace().getRemote());
        } else {
            args.add(this.getResolvedString(this.defaultDocumentDirectory, build, listener));
        }
        args.add("-GlobalResultsFolder");
        if (this.globalResultsFolder.isEmpty()) {
            args.add(build.getWorkspace().getRemote());
        } else {
            args.add(this.getResolvedString(this.globalResultsFolder, build, listener));
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getInstance().getDescriptorOrDie(eggPlantBuilder.class);
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile EggPlantInstallation[] installations = new EggPlantInstallation[0];

        public DescriptorImpl() {
            super(eggPlantBuilder.class);
            this.load();
        }

        public EggPlantInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(EggPlantInstallation[] installations) {
            this.installations = installations;
            this.save();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "EggPlant";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

