/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import hudson.model.Node;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.ConnectionStrategy;
import hudson.plugins.ec2.EC2Tag;
import hudson.slaves.NodeProperty;
import java.util.List;

public abstract class EC2AgentConfig {
    final String name;
    final String description;
    final String remoteFS;
    final int numExecutors;
    final String labelString;
    final Node.Mode mode;
    final String initScript;
    final String tmpDir;
    final List<? extends NodeProperty<?>> nodeProperties;
    final String remoteAdmin;
    final String jvmopts;
    final String idleTerminationMinutes;
    final List<EC2Tag> tags;
    final String cloudName;
    final int launchTimeout;
    final AMITypeData amiType;
    final ConnectionStrategy connectionStrategy;
    final int maxTotalUses;

    private EC2AgentConfig(Builder<? extends Builder, ? extends EC2AgentConfig> builder) {
        this.name = ((Builder)builder).name;
        this.description = ((Builder)builder).description;
        this.remoteFS = ((Builder)builder).remoteFS;
        this.numExecutors = ((Builder)builder).numExecutors;
        this.labelString = ((Builder)builder).labelString;
        this.mode = ((Builder)builder).mode;
        this.initScript = ((Builder)builder).initScript;
        this.tmpDir = ((Builder)builder).tmpDir;
        this.nodeProperties = ((Builder)builder).nodeProperties;
        this.remoteAdmin = ((Builder)builder).remoteAdmin;
        this.jvmopts = ((Builder)builder).jvmopts;
        this.idleTerminationMinutes = ((Builder)builder).idleTerminationMinutes;
        this.tags = ((Builder)builder).tags;
        this.cloudName = ((Builder)builder).cloudName;
        this.launchTimeout = ((Builder)builder).launchTimeout;
        this.amiType = ((Builder)builder).amiType;
        this.connectionStrategy = ((Builder)builder).connectionStrategy;
        this.maxTotalUses = ((Builder)builder).maxTotalUses;
    }

    private static abstract class Builder<B extends Builder<B, C>, C extends EC2AgentConfig> {
        private String name;
        private String description;
        private String remoteFS;
        private int numExecutors;
        private String labelString;
        private Node.Mode mode;
        private String initScript;
        private String tmpDir;
        private List<? extends NodeProperty<?>> nodeProperties;
        private String remoteAdmin;
        private String jvmopts;
        private String idleTerminationMinutes;
        private List<EC2Tag> tags;
        private String cloudName;
        private int launchTimeout;
        private AMITypeData amiType;
        private ConnectionStrategy connectionStrategy;
        private int maxTotalUses;

        private Builder() {
        }

        public B withName(String name) {
            this.name = name;
            return this.self();
        }

        public B withDescription(String description) {
            this.description = description;
            return this.self();
        }

        public B withRemoteFS(String remoteFS) {
            this.remoteFS = remoteFS;
            return this.self();
        }

        public B withNumExecutors(int numExecutors) {
            this.numExecutors = numExecutors;
            return this.self();
        }

        public B withLabelString(String labelString) {
            this.labelString = labelString;
            return this.self();
        }

        public B withMode(Node.Mode mode) {
            this.mode = mode;
            return this.self();
        }

        public B withInitScript(String initScript) {
            this.initScript = initScript;
            return this.self();
        }

        public B withTmpDir(String tmpDir) {
            this.tmpDir = tmpDir;
            return this.self();
        }

        public B withNodeProperties(List<? extends NodeProperty<?>> nodeProperties) {
            this.nodeProperties = nodeProperties;
            return this.self();
        }

        public List<? extends NodeProperty<?>> getNodeProperties() {
            return this.nodeProperties;
        }

        public B withRemoteAdmin(String remoteAdmin) {
            this.remoteAdmin = remoteAdmin;
            return this.self();
        }

        public B withJvmopts(String jvmopts) {
            this.jvmopts = jvmopts;
            return this.self();
        }

        public B withIdleTerminationMinutes(String idleTerminationMinutes) {
            this.idleTerminationMinutes = idleTerminationMinutes;
            return this.self();
        }

        public B withTags(List<EC2Tag> tags) {
            this.tags = tags;
            return this.self();
        }

        public B withCloudName(String cloudName) {
            this.cloudName = cloudName;
            return this.self();
        }

        public B withLaunchTimeout(int launchTimeout) {
            this.launchTimeout = launchTimeout;
            return this.self();
        }

        public B withAmiType(AMITypeData amiType) {
            this.amiType = amiType;
            return this.self();
        }

        public B withConnectionStrategy(ConnectionStrategy connectionStrategy) {
            this.connectionStrategy = connectionStrategy;
            return this.self();
        }

        public B withMaxTotalUses(int maxTotalUses) {
            this.maxTotalUses = maxTotalUses;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();
    }

    public static class SpotBuilder
    extends Builder<SpotBuilder, Spot> {
        private String spotInstanceRequestId;

        public SpotBuilder withSpotInstanceRequestId(String spotInstanceRequestId) {
            this.spotInstanceRequestId = spotInstanceRequestId;
            return this;
        }

        @Override
        protected SpotBuilder self() {
            return this;
        }

        @Override
        public Spot build() {
            return new Spot(this);
        }
    }

    public static class OnDemandBuilder
    extends Builder<OnDemandBuilder, OnDemand> {
        private String instanceId;
        private boolean stopOnTerminate;
        private String publicDNS;
        private String privateDNS;
        private boolean useDedicatedTenancy;

        public OnDemandBuilder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public OnDemandBuilder withStopOnTerminate(boolean stopOnTerminate) {
            this.stopOnTerminate = stopOnTerminate;
            return this;
        }

        public boolean isStopOnTerminate() {
            return this.stopOnTerminate;
        }

        public OnDemandBuilder withPublicDNS(String publicDNS) {
            this.publicDNS = publicDNS;
            return this;
        }

        public String getPublicDNS() {
            return this.publicDNS;
        }

        public OnDemandBuilder withPrivateDNS(String privateDNS) {
            this.privateDNS = privateDNS;
            return this;
        }

        public String getPrivateDNS() {
            return this.privateDNS;
        }

        public OnDemandBuilder withUseDedicatedTenancy(boolean useDedicatedTenancy) {
            this.useDedicatedTenancy = useDedicatedTenancy;
            return this;
        }

        public boolean isUseDedicatedTenancy() {
            return this.useDedicatedTenancy;
        }

        @Override
        protected OnDemandBuilder self() {
            return this;
        }

        @Override
        public OnDemand build() {
            return new OnDemand(this);
        }
    }

    public static class Spot
    extends EC2AgentConfig {
        final String spotInstanceRequestId;

        private Spot(SpotBuilder builder) {
            super(builder);
            this.spotInstanceRequestId = builder.spotInstanceRequestId;
        }
    }

    public static class OnDemand
    extends EC2AgentConfig {
        final String instanceId;
        final boolean stopOnTerminate;
        final String publicDNS;
        final String privateDNS;
        final boolean useDedicatedTenancy;

        private OnDemand(OnDemandBuilder builder) {
            super(builder);
            this.instanceId = builder.getInstanceId();
            this.stopOnTerminate = builder.isStopOnTerminate();
            this.publicDNS = builder.getPublicDNS();
            this.privateDNS = builder.getPrivateDNS();
            this.useDedicatedTenancy = builder.isUseDedicatedTenancy();
        }
    }
}

