/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.verifiers;

import hudson.XmlFile;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.plugins.ec2.ssh.verifiers.HostKey;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import jenkins.model.Jenkins;

public final class HostKeyHelper {
    private static final HostKeyHelper INSTANCE = new HostKeyHelper();
    private final Map<Computer, HostKey> cache = new WeakHashMap<Computer, HostKey>();

    private HostKeyHelper() {
    }

    public static HostKeyHelper getInstance() {
        return INSTANCE;
    }

    public HostKey getHostKey(Computer host) throws IOException {
        HostKey key = this.cache.get(host);
        if (null == key) {
            File hostKeyFile = this.getSshHostKeyFile(host.getNode());
            if (hostKeyFile.exists()) {
                XmlFile xmlHostKeyFile = new XmlFile(hostKeyFile);
                key = (HostKey)xmlHostKeyFile.read();
            } else {
                key = null;
            }
            this.cache.put(host, key);
        }
        return key;
    }

    public void saveHostKey(Computer host, HostKey hostKey) throws IOException {
        XmlFile xmlHostKeyFile = new XmlFile(this.getSshHostKeyFile(host.getNode()));
        xmlHostKeyFile.write((Object)hostKey);
        this.cache.put(host, hostKey);
    }

    private File getSshHostKeyFile(Node node) throws IOException {
        return new File(this.getNodeDirectory(node), "ssh-host-key.xml");
    }

    private File getNodeDirectory(Node node) throws IOException {
        if (null == node) {
            throw new IOException("Could not load key for the requested node");
        }
        return new File(this.getNodesDirectory(), node.getNodeName());
    }

    private File getNodesDirectory() throws IOException {
        File nodesDir = new File(Jenkins.get().getRootDir(), "nodes");
        if (!nodesDir.exists() || !nodesDir.isDirectory()) {
            throw new IOException("Nodes directory does not exist");
        }
        return nodesDir;
    }
}

