/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.verifiers;

import com.trilead.ssh2.KnownHosts;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.Arrays;

public final class HostKey
implements Serializable {
    private static final long serialVersionUID = -3873284593211178494L;
    private final String algorithm;
    private final byte[] key;

    public HostKey(@NonNull String algorithm, @NonNull byte[] key) {
        this.algorithm = algorithm;
        this.key = (byte[])key.clone();
    }

    @NonNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @NonNull
    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public String getFingerprint() {
        return KnownHosts.createHexFingerprint((String)this.getAlgorithm(), (byte[])this.getKey());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostKey other = (HostKey)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        return Arrays.equals(this.key, other.key);
    }
}

