/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.services.ec2.model.Instance;
import hudson.Extension;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.TaskListener;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class EC2Step
extends Step {
    private String cloud;
    private String template;

    @DataBoundConstructor
    public EC2Step(String cloud, String template) {
        this.cloud = cloud;
        this.template = template;
    }

    public String getCloud() {
        return this.cloud;
    }

    public String getTemplate() {
        return this.template;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Instance> {
        private final String cloud;
        private final String template;

        Execution(EC2Step step, StepContext context) {
            super(context);
            this.cloud = step.cloud;
            this.template = step.template;
        }

        protected Instance run() throws Exception {
            Cloud cl = this.getByDisplayName((Jenkins.CloudList)Jenkins.get().clouds, this.cloud);
            if (cl instanceof AmazonEC2Cloud) {
                SlaveTemplate t = ((AmazonEC2Cloud)cl).getTemplate(this.template);
                if (t != null) {
                    SlaveTemplate.ProvisionOptions universe = SlaveTemplate.ProvisionOptions.ALLOW_CREATE;
                    EnumSet<SlaveTemplate.ProvisionOptions> opt = EnumSet.noneOf(SlaveTemplate.ProvisionOptions.class);
                    opt.add(universe);
                    List<EC2AbstractSlave> instances = t.provision(1, opt);
                    if (instances == null) {
                        throw new IllegalArgumentException("Error in AWS Cloud. Please review AWS template defined in Jenkins configuration.");
                    }
                    EC2AbstractSlave slave = instances.get(0);
                    return CloudHelper.getInstanceWithRetry(slave.getInstanceId(), (AmazonEC2Cloud)cl);
                }
                throw new IllegalArgumentException("Error in AWS Cloud. Please review AWS template defined in Jenkins configuration.");
            }
            throw new IllegalArgumentException("Error in AWS Cloud. Please review EC2 settings in Jenkins configuration.");
        }

        public Cloud getByDisplayName(Jenkins.CloudList clouds, String name) {
            Iterator i$ = clouds.iterator();
            Cloud c = (Cloud)i$.next();
            while (!c.getDisplayName().equals(name)) {
                if (!i$.hasNext()) {
                    return null;
                }
                c = (Cloud)i$.next();
            }
            return c;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "ec2";
        }

        public String getDisplayName() {
            return "Cloud template provisioning";
        }

        public ListBoxModel doFillCloudItems() {
            ListBoxModel r = new ListBoxModel();
            r.add("", "");
            Hudson.CloudList clouds = Jenkins.get().clouds;
            for (Cloud cList : clouds) {
                if (!(cList instanceof AmazonEC2Cloud)) continue;
                r.add(cList.getDisplayName(), cList.getDisplayName());
            }
            return r;
        }

        public ListBoxModel doFillTemplateItems(@QueryParameter String cloud) {
            cloud = Util.fixEmpty((String)cloud);
            ListBoxModel r = new ListBoxModel();
            for (Cloud cList : Jenkins.get().clouds) {
                if (!cList.getDisplayName().equals(cloud)) continue;
                List<SlaveTemplate> templates = ((AmazonEC2Cloud)cList).getTemplates();
                for (SlaveTemplate template : templates) {
                    for (String labelList : template.labels.split(" ")) {
                        r.add(labelList + "  (AMI: " + template.getAmi() + ", REGION: " + ((AmazonEC2Cloud)cList).getRegion() + ", TYPE: " + template.type.name() + ")", labelList);
                    }
                }
            }
            return r;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

