/*
 * Decompiled with CFR 0.152.
 */
package hudson.os;

import hudson.Functions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class WindowsUtil {
    private static final Pattern NEEDS_QUOTING = Pattern.compile("[\\s\"]");
    private static final Pattern CMD_METACHARS = Pattern.compile("[()%!^\"<>&|]");

    @Nonnull
    public static String quoteArgument(@Nonnull String argument) {
        if (!NEEDS_QUOTING.matcher(argument).find()) {
            return argument;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        int end = argument.length();
        for (int i = 0; i < end; ++i) {
            int nrBackslashes = 0;
            while (i < end && argument.charAt(i) == '\\') {
                ++i;
                ++nrBackslashes;
            }
            if (i == end) {
                nrBackslashes *= 2;
            } else if (argument.charAt(i) == '\"') {
                nrBackslashes = nrBackslashes * 2 + 1;
            }
            for (int j = 0; j < nrBackslashes; ++j) {
                sb.append('\\');
            }
            if (i >= end) continue;
            sb.append(argument.charAt(i));
        }
        return sb.append('\"').toString();
    }

    @Nonnull
    public static String quoteArgumentForCmd(@Nonnull String argument) {
        return CMD_METACHARS.matcher(WindowsUtil.quoteArgument(argument)).replaceAll("^$0");
    }

    @Nonnull
    public static Process execCmd(String ... argv) throws IOException {
        String command = Arrays.stream(argv).map(WindowsUtil::quoteArgumentForCmd).collect(Collectors.joining(" "));
        return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", command});
    }

    @Nonnull
    public static File createJunction(@Nonnull File junction, @Nonnull File target) throws IOException, InterruptedException {
        if (!Functions.isWindows()) {
            throw new UnsupportedOperationException("Can only be called on windows platform");
        }
        Process mklink = WindowsUtil.execCmd("mklink", "/J", junction.getAbsolutePath(), target.getAbsolutePath());
        int result = mklink.waitFor();
        if (result != 0) {
            String stderr = IOUtils.toString((InputStream)mklink.getErrorStream());
            String stdout = IOUtils.toString((InputStream)mklink.getInputStream());
            throw new IOException("Process exited with " + result + "\nStandard Output:\n" + stdout + "\nError Output:\n" + stderr);
        }
        return junction;
    }
}

