/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.util.MinimumNumberOfInstancesTimeRangeConfig;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class MinimumInstanceChecker {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Needs to be overridden from tests")
    public static Clock clock = Clock.systemDefaultZone();

    public static int countCurrentNumberOfAgents(@Nonnull SlaveTemplate slaveTemplate) {
        return (int)Arrays.stream(Jenkins.get().getComputers()).filter(computer -> {
            SlaveTemplate computerTemplate;
            if (computer instanceof EC2Computer && (computerTemplate = ((EC2Computer)((Object)computer)).getSlaveTemplate()) != null) {
                return Objects.equals(computerTemplate.description, slaveTemplate.description);
            }
            return false;
        }).count();
    }

    public static void checkForMinimumInstances() {
        Jenkins.get().clouds.stream().filter(cloud -> cloud instanceof EC2Cloud).map(cloud -> (EC2Cloud)((Object)cloud)).forEach(cloud -> cloud.getTemplates().forEach(slaveTemplate -> {
            if (slaveTemplate.getMinimumNumberOfInstances() > 0 && MinimumInstanceChecker.minimumInstancesActive(slaveTemplate.getMinimumNumberOfInstancesTimeRangeConfig())) {
                int currentNumberOfSlavesForTemplate = MinimumInstanceChecker.countCurrentNumberOfAgents(slaveTemplate);
                int numberToProvision = slaveTemplate.getMinimumNumberOfInstances() - currentNumberOfSlavesForTemplate;
                if (numberToProvision > 0) {
                    cloud.provision((SlaveTemplate)slaveTemplate, numberToProvision);
                }
            }
        }));
    }

    public static boolean minimumInstancesActive(MinimumNumberOfInstancesTimeRangeConfig minimumNumberOfInstancesTimeRangeConfig) {
        if (minimumNumberOfInstancesTimeRangeConfig == null) {
            return true;
        }
        LocalTime fromTime = minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeFromAsTime();
        LocalTime toTime = minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeToAsTime();
        LocalDateTime now = LocalDateTime.now(clock);
        LocalTime nowTime = LocalTime.from(now);
        boolean passingMidnight = false;
        if (toTime.isBefore(fromTime)) {
            passingMidnight = true;
        }
        if (passingMidnight) {
            if (nowTime.isAfter(fromTime)) {
                String today = now.getDayOfWeek().name().toLowerCase();
                return minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeDays().get(today);
            }
            if (nowTime.isBefore(toTime)) {
                String yesterday = now.minusDays(1L).getDayOfWeek().name().toLowerCase();
                return minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeDays().get(yesterday);
            }
        } else if (nowTime.isAfter(fromTime) && nowTime.isBefore(toTime)) {
            String today = now.getDayOfWeek().name().toLowerCase();
            return minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeDays().get(today);
        }
        return false;
    }
}

